/*
 * Decompiled with CFR 0.152.
 */
package quicktime.internal.jdirect;

import quicktime.internal.jdirect.ArrayCopy;
import quicktime.internal.jdirect.Struct;

public class ShortArrayStruct
extends Struct {
    protected short[] shorts;
    private int logicalSize;

    protected ShortArrayStruct(int sizeInBytes) {
        this.logicalSize = sizeInBytes;
        this.shorts = new short[(sizeInBytes + 1) / 2];
    }

    protected final byte getByteAt(int offset) {
        short temp = this.shorts[offset / 2];
        if (offset % 2 == 0 == Struct.IS_BIG_ENDIAN) {
            return (byte)(temp >>> 8);
        }
        return (byte)(temp & 0xFF);
    }

    protected final short getShortAt(int offset) {
        if (offset % 2 == 0) {
            return this.shorts[offset / 2];
        }
        return super.getShortAt(offset);
    }

    protected final void setByteAt(int offset, byte value) {
        short temp = this.shorts[offset / 2];
        this.shorts[offset / 2] = offset % 2 == 0 == Struct.IS_BIG_ENDIAN ? (short)(temp & 0xFF | value << 8) : (short)(temp & 0xFF00 | value);
    }

    protected final void setShortAt(int offset, short value) {
        if (offset % 2 == 0) {
            this.shorts[offset / 2] = value;
        } else {
            super.setShortAt(offset, value);
        }
    }

    protected void setBytesAt(int byteOffset, byte[] source) {
        ArrayCopy.copyArrayToArray(source, 0, this.shorts, byteOffset, source.length);
    }

    protected void setStructAt(int byteOffset, Struct src) {
        int srcByteCount = src.getSize();
        ArrayCopy.copyArrayToArray(src.getBytesAt(0, srcByteCount), 0, this.shorts, byteOffset, srcByteCount);
    }

    public byte[] getBytesAt(int byteOffset, int byteCount) {
        byte[] result = new byte[byteCount];
        ArrayCopy.copyArrayToArray(this.shorts, byteOffset, result, 0, byteCount);
        return result;
    }

    public byte[] getBytes() {
        return this.getBytesAt(0, this.getSize());
    }

    public final short[] getArray() {
        return this.shorts;
    }

    public final int getSize() {
        return this.logicalSize;
    }
}

