/*
 * Decompiled with CFR 0.152.
 */
package quicktime.internal.jdirect;

import quicktime.internal.jdirect.LinkerAbstract;

public class StringUtil {
    public static int toCFString(String str) {
        char[] chars = str.toCharArray();
        int result = StringUtil.CFStringCreateWithCharacters(0, chars, chars.length);
        if (result == 0) {
            throw new OutOfMemoryError("in CFStringCreateWithCharacters");
        }
        return result;
    }

    public static String fromCFString(int cfstringRef) {
        int len = StringUtil.CFStringGetLength(cfstringRef);
        char[] unichars = new char[len];
        long range = len;
        StringUtil.CFStringGetCharacters(cfstringRef, range, unichars);
        return new String(unichars);
    }

    private static native int CFStringCreateWithCharacters(int var0, char[] var1, int var2);

    private static native void CFStringGetCharacters(int var0, long var1, char[] var3);

    private static native int CFStringGetLength(int var0);

    public static byte[] toCString(String str) {
        byte[] bytes = str.getBytes();
        byte[] cBytes = new byte[bytes.length + 1];
        System.arraycopy(bytes, 0, cBytes, 0, bytes.length);
        cBytes[bytes.length] = 0;
        return cBytes;
    }

    public static String fromCString(byte[] cStr) {
        int len = cStr.length;
        int i = 0;
        while (i < len) {
            if (cStr[i] == 0) {
                len = i;
                break;
            }
            ++i;
        }
        return new String(cStr, 0, len);
    }

    public static byte[] toPascalString(String str) {
        byte[] bytes = str.getBytes();
        int len = Math.min(bytes.length, 255);
        byte[] pascalBytes = new byte[len + 1];
        pascalBytes[0] = (byte)len;
        System.arraycopy(bytes, 0, pascalBytes, 1, len);
        return pascalBytes;
    }

    public static String fromPascalString(byte[] pStr) {
        return new String(pStr, 1, pStr[0] & 0xFF);
    }

    static {
        LinkerAbstract.loadJNILibrary();
    }
}

