/*
 * Decompiled with CFR 0.152.
 */
package quicktime.internal.jdirect;

public abstract class Struct {
    protected static final boolean IS_BIG_ENDIAN = Struct.isBigEndian();
    protected static final int SHORT_LOW_BYTE_OFFSET = IS_BIG_ENDIAN ? 1 : 0;
    protected static final int SHORT_HIGH_BYTE_OFFSET = IS_BIG_ENDIAN ? 0 : 1;
    protected static final int INT_LOW_SHORT_OFFSET = IS_BIG_ENDIAN ? 2 : 0;
    protected static final int INT_HIGH_SHORT_OFFSET = IS_BIG_ENDIAN ? 0 : 2;
    protected static final int LONG_LOW_INT_OFFSET = IS_BIG_ENDIAN ? 4 : 0;
    protected static final int LONG_HIGH_INT_OFFSET = IS_BIG_ENDIAN ? 0 : 4;
    protected static final int INT_LOW_BYTE_OFFSET = IS_BIG_ENDIAN ? 3 : 0;
    protected static final int INT_TWO_BYTE_OFFSET = IS_BIG_ENDIAN ? 2 : 1;
    protected static final int INT_THREE_BYTE_OFFSET = IS_BIG_ENDIAN ? 1 : 2;
    protected static final int INT_HIGH_BYTE_OFFSET = IS_BIG_ENDIAN ? 0 : 3;
    protected static final int LONG_LOW_BYTE_OFFSET = IS_BIG_ENDIAN ? 7 : 0;
    protected static final int LONG_TWO_BYTE_OFFSET = IS_BIG_ENDIAN ? 6 : 1;
    protected static final int LONG_THREE_BYTE_OFFSET = IS_BIG_ENDIAN ? 5 : 2;
    protected static final int LONG_FOUR_BYTE_OFFSET = IS_BIG_ENDIAN ? 4 : 3;
    protected static final int LONG_FIVE_BYTE_OFFSET = IS_BIG_ENDIAN ? 3 : 4;
    protected static final int LONG_SIX_BYTE_OFFSET = IS_BIG_ENDIAN ? 2 : 5;
    protected static final int LONG_SEVEN_BYTE_OFFSET = IS_BIG_ENDIAN ? 1 : 6;
    protected static final int LONG_HIGH_BYTE_OFFSET = IS_BIG_ENDIAN ? 0 : 7;

    protected Struct() {
    }

    protected boolean getBooleanAt(int byteOffset) {
        return this.getByteAt(byteOffset) != 0;
    }

    protected abstract byte getByteAt(int var1);

    protected char getCharAt(int byteOffset) {
        return (char)this.getShortAt(byteOffset);
    }

    protected short getShortAt(int byteOffset) {
        return (short)(this.getByteAt(byteOffset + SHORT_HIGH_BYTE_OFFSET) << 8 | this.getByteAt(byteOffset + SHORT_LOW_BYTE_OFFSET) & 0xFF);
    }

    protected int getIntAt(int byteOffset) {
        return this.getShortAt(byteOffset + INT_LOW_SHORT_OFFSET) << 16 | this.getShortAt(byteOffset + INT_HIGH_SHORT_OFFSET) & 0xFFFF;
    }

    protected long getLongAt(int byteOffset) {
        return (long)this.getIntAt(byteOffset + LONG_HIGH_INT_OFFSET) << 32 | (long)this.getIntAt(byteOffset + LONG_LOW_INT_OFFSET) & 0xFFFFFFFFL;
    }

    protected float getFloatAt(int byteOffset) {
        return Float.intBitsToFloat(this.getIntAt(byteOffset));
    }

    protected double getDoubleAt(int byteOffset) {
        return Double.longBitsToDouble(this.getLongAt(byteOffset));
    }

    protected void setBooleanAt(int byteOffset, boolean value) {
        this.setByteAt(byteOffset, value ? (byte)1 : 0);
    }

    protected abstract void setByteAt(int var1, byte var2);

    protected void setCharAt(int byteOffset, char value) {
        this.setShortAt(byteOffset, (short)value);
    }

    protected void setShortAt(int byteOffset, short value) {
        this.setByteAt(byteOffset + SHORT_HIGH_BYTE_OFFSET, (byte)(value >>> 8));
        this.setByteAt(byteOffset + SHORT_LOW_BYTE_OFFSET, (byte)value);
    }

    protected void setIntAt(int byteOffset, int value) {
        this.setShortAt(byteOffset + INT_HIGH_SHORT_OFFSET, (short)(value >>> 16));
        this.setShortAt(byteOffset + INT_LOW_SHORT_OFFSET, (short)value);
    }

    protected void setLongAt(int byteOffset, long value) {
        this.setIntAt(byteOffset + LONG_HIGH_INT_OFFSET, (int)(value >>> 32));
        this.setIntAt(byteOffset + LONG_LOW_INT_OFFSET, (int)value);
    }

    protected void setFloatAt(int byteOffset, float value) {
        this.setIntAt(byteOffset, Float.floatToRawIntBits(value));
    }

    protected void setDoubleAt(int byteOffset, double value) {
        this.setLongAt(byteOffset, Double.doubleToRawLongBits(value));
    }

    protected abstract void setStructAt(int var1, Struct var2);

    protected abstract void setBytesAt(int var1, byte[] var2);

    public abstract byte[] getBytesAt(int var1, int var2);

    public abstract byte[] getBytes();

    public abstract int getSize();

    private static native boolean isBigEndian();
}

