/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmfsound.imp;

import com.sun.jmfsound.imp.AiffFileFormat;
import com.sun.jmfsound.imp.SunFileWriter;
import com.sun.jmfsound.sampled.AudioFileFormat;
import com.sun.jmfsound.sampled.AudioFormat;
import com.sun.jmfsound.sampled.AudioInputStream;
import com.sun.jmfsound.sampled.AudioSystem;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.SequenceInputStream;

public class AiffFileWriter
extends SunFileWriter {
    static final int AIFF_HEADERSIZE = 54;
    private static final AudioFileFormat.Type[] aiffTypes = new AudioFileFormat.Type[]{AudioFileFormat.Type.AIFF};

    public AiffFileWriter() {
        super(aiffTypes);
    }

    public AudioFileFormat.Type[] getAudioFileTypes(AudioInputStream stream) {
        AudioFileFormat.Type[] filetypes = new AudioFileFormat.Type[this.types.length];
        System.arraycopy(this.types, 0, filetypes, 0, this.types.length);
        AudioFormat format = stream.getFormat();
        AudioFormat.Encoding encoding = format.getEncoding();
        if (encoding == AudioFormat.Encoding.ALAW || encoding == AudioFormat.Encoding.ULAW || encoding == AudioFormat.Encoding.PCM_SIGNED || encoding == AudioFormat.Encoding.PCM_UNSIGNED) {
            return filetypes;
        }
        return new AudioFileFormat.Type[0];
    }

    public int write(AudioInputStream stream, AudioFileFormat.Type fileType, OutputStream out) throws IOException {
        if (stream.getFrameLength() == -1L) {
            throw new IOException("stream length not specified");
        }
        AiffFileFormat aiffFileFormat = (AiffFileFormat)this.getAudioFileFormat(fileType, stream);
        int bytesWritten = this.writeAiffFile(stream, aiffFileFormat, out);
        return bytesWritten;
    }

    public int write(AudioInputStream stream, AudioFileFormat.Type fileType, File out) throws IOException {
        AiffFileFormat aiffFileFormat = (AiffFileFormat)this.getAudioFileFormat(fileType, stream);
        FileOutputStream fos = new FileOutputStream(out);
        BufferedOutputStream bos = new BufferedOutputStream(fos, 4096);
        int bytesWritten = this.writeAiffFile(stream, aiffFileFormat, bos);
        bos.close();
        if (aiffFileFormat.getByteLength() == -1) {
            // empty if block
        }
        return bytesWritten;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private AudioFileFormat getAudioFileFormat(AudioFileFormat.Type type, AudioInputStream stream) {
        int sampleSizeInBits;
        AudioFormat format = null;
        AiffFileFormat fileFormat = null;
        AudioFormat.Encoding encoding = AudioFormat.Encoding.PCM_SIGNED;
        AudioFormat streamFormat = stream.getFormat();
        AudioFormat.Encoding streamEncoding = streamFormat.getEncoding();
        boolean convert8to16 = false;
        if (type != this.types[0]) {
            throw new IllegalArgumentException("File type " + type + " not supported.");
        }
        if (streamEncoding == AudioFormat.Encoding.ALAW || streamEncoding == AudioFormat.Encoding.ULAW) {
            if (streamFormat.getSampleSizeInBits() != 8) throw new IllegalArgumentException("Encoding " + streamEncoding + " supported only for 8-bit data.");
            encoding = AudioFormat.Encoding.PCM_SIGNED;
            sampleSizeInBits = 16;
            convert8to16 = true;
        } else if (streamFormat.getSampleSizeInBits() == 8) {
            encoding = AudioFormat.Encoding.PCM_UNSIGNED;
            sampleSizeInBits = 8;
        } else {
            encoding = AudioFormat.Encoding.PCM_SIGNED;
            sampleSizeInBits = streamFormat.getSampleSizeInBits();
        }
        format = new AudioFormat(encoding, streamFormat.getSampleRate(), sampleSizeInBits, streamFormat.getChannels(), streamFormat.getFrameSize(), streamFormat.getFrameRate(), true);
        int fileSize = stream.getFrameLength() != -1L ? (convert8to16 ? (int)stream.getFrameLength() * streamFormat.getFrameSize() * 2 + 54 : (int)stream.getFrameLength() * streamFormat.getFrameSize() + 54) : -1;
        return new AiffFileFormat(AudioFileFormat.Type.AIFF, fileSize, format, (int)stream.getFrameLength());
    }

    private int writeAiffFile(InputStream in, AiffFileFormat aiffFileFormat, OutputStream out) throws IOException {
        int bytesRead = 0;
        int bytesWritten = 0;
        InputStream fileStream = this.getFileStream(aiffFileFormat, in);
        byte[] buffer = new byte[4096];
        int maxLength = aiffFileFormat.getByteLength();
        while ((bytesRead = fileStream.read(buffer)) >= 0) {
            if (maxLength > 0) {
                if (bytesRead < maxLength) {
                    out.write(buffer, 0, bytesRead);
                    bytesWritten += bytesRead;
                    maxLength -= bytesRead;
                    continue;
                }
                out.write(buffer, 0, maxLength);
                bytesWritten += maxLength;
                maxLength = 0;
                break;
            }
            out.write(buffer, 0, bytesRead);
            bytesWritten += bytesRead;
        }
        return bytesWritten;
    }

    private InputStream getFileStream(AiffFileFormat aiffFileFormat, InputStream audioStream) throws IOException {
        AudioFormat format = aiffFileFormat.getFormat();
        AudioFormat streamFormat = null;
        AudioFormat.Encoding encoding = null;
        int headerSize = 54;
        boolean fverChunkSize = false;
        int commChunkSize = 26;
        int aiffLength = -1;
        int ssndChunkSize = -1;
        int ssndOffset = headerSize - 16;
        short channels = (short)format.getChannels();
        short sampleSize = (short)format.getSampleSizeInBits();
        int ssndBlockSize = channels * sampleSize;
        int numFrames = aiffFileFormat.getFrameLength();
        long dataSize = -1L;
        if (numFrames != -1) {
            dataSize = (long)numFrames * (long)ssndBlockSize / 8L;
            ssndChunkSize = (int)dataSize + 16;
            aiffLength = (int)dataSize + headerSize;
        }
        float sampleFramesPerSecond = format.getSampleRate();
        int compCode = 1313820229;
        byte[] header = null;
        ByteArrayInputStream headerStream = null;
        ByteArrayOutputStream baos = null;
        DataOutputStream dos = null;
        SequenceInputStream aiffStream = null;
        InputStream codedAudioStream = audioStream;
        if (audioStream instanceof AudioInputStream) {
            streamFormat = ((AudioInputStream)audioStream).getFormat();
            encoding = streamFormat.getEncoding();
            if (encoding == AudioFormat.Encoding.PCM_UNSIGNED || encoding == AudioFormat.Encoding.PCM_SIGNED && !streamFormat.isBigEndian()) {
                codedAudioStream = AudioSystem.getAudioInputStream(new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, streamFormat.getSampleRate(), streamFormat.getSampleSizeInBits(), streamFormat.getChannels(), streamFormat.getFrameSize(), streamFormat.getFrameRate(), true), (AudioInputStream)audioStream);
            } else if (encoding == AudioFormat.Encoding.ULAW || encoding == AudioFormat.Encoding.ALAW) {
                if (streamFormat.getSampleSizeInBits() != 8) {
                    throw new IllegalArgumentException("unsupported encoding");
                }
                codedAudioStream = AudioSystem.getAudioInputStream(new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, streamFormat.getSampleRate(), streamFormat.getSampleSizeInBits() * 2, streamFormat.getChannels(), streamFormat.getFrameSize() * 2, streamFormat.getFrameRate(), true), (AudioInputStream)audioStream);
            }
        }
        baos = new ByteArrayOutputStream();
        dos = new DataOutputStream(baos);
        dos.writeInt(1179603533);
        dos.writeInt(aiffLength - 8);
        dos.writeInt(1095321158);
        dos.writeInt(1129270605);
        dos.writeInt(commChunkSize - 8);
        dos.writeShort(channels);
        dos.writeInt(numFrames);
        dos.writeShort(sampleSize);
        this.write_ieee_extended(dos, sampleFramesPerSecond);
        dos.writeInt(1397968452);
        dos.writeInt(ssndChunkSize - 8);
        dos.writeInt(0);
        dos.writeInt(0);
        dos.close();
        header = baos.toByteArray();
        headerStream = new ByteArrayInputStream(header);
        aiffStream = new SequenceInputStream(headerStream, codedAudioStream);
        return aiffStream;
    }

    private void write_ieee_extended(DataOutputStream dos, double f) throws IOException {
        int exponent = 16398;
        double highMantissa = f;
        while (highMantissa < 44000.0) {
            highMantissa *= 2.0;
            --exponent;
        }
        dos.writeShort(exponent);
        dos.writeInt((int)highMantissa << 16);
        dos.writeInt(0);
    }
}

