/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmfsound.imp;

import com.sun.jmfsound.imp.JDK12;
import com.sun.jmfsound.imp.JDK12NewEventDispatcherAction;
import com.sun.jmfsound.imp.JSSecurity;
import com.sun.jmfsound.imp.JSSecurityManager;
import com.sun.jmfsound.imp.Printer;
import com.sun.jmfsound.midi.ControllerEventListener;
import com.sun.jmfsound.midi.MetaEventListener;
import com.sun.jmfsound.midi.MetaMessage;
import com.sun.jmfsound.midi.ShortMessage;
import com.sun.jmfsound.sampled.LineEvent;
import com.sun.jmfsound.sampled.LineListener;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Vector;

class EventDispatcher
implements Runnable {
    private Vector eventQueue = new Vector();
    private boolean done = false;
    Thread thread = null;
    static boolean creatingThread = false;
    private static JSSecurity jsSecurity = null;
    private static boolean securityPrivilege = false;
    private Method[] m = new Method[1];
    private Class[] cl = new Class[1];
    private Object[][] args = new Object[1][0];

    EventDispatcher() {
    }

    void start() {
        if (this.thread == null && !creatingThread || this.done) {
            EventDispatcher localRunnable = this;
            this.done = false;
            if (securityPrivilege && jsSecurity != null) {
                if (jsSecurity.getName().startsWith("JDK12")) {
                    try {
                        creatingThread = true;
                        Constructor cons = JDK12NewEventDispatcherAction.cons;
                        Object[] args = new Object[]{localRunnable};
                        this.thread = (Thread)JDK12.doPrivM.invoke((Object)JDK12.ac, cons.newInstance(args));
                        if (Printer.debug) {
                            Printer.debug("Got EventDispatcher with 1.2 style security");
                        }
                        creatingThread = false;
                    }
                    catch (InstantiationException ise) {
                        if (Printer.debug) {
                            Printer.debug("InstantiationException getting event dispatcher with 1.2 style security: " + ise);
                        }
                        this.thread = new Thread(this);
                        this.thread.start();
                    }
                    catch (IllegalAccessException iae) {
                        if (Printer.debug) {
                            Printer.debug("IllegalAccessException getting event dispatcher with 1.2 style security: " + iae);
                        }
                        this.thread = new Thread(this);
                        this.thread.start();
                    }
                    catch (InvocationTargetException ite) {
                        if (Printer.debug) {
                            Printer.debug("InvocationTargetException getting event dispatcher with 1.2 style security: " + ite);
                        }
                        this.thread = new Thread(this);
                        this.thread.start();
                    }
                } else {
                    block19: {
                        try {
                            jsSecurity.requestPermission(this.m, this.cl, this.args, 16);
                            this.m[0].invoke((Object)this.cl[0], this.args[0]);
                            if (Printer.debug) {
                                Printer.debug("EventDispatcher.start(): got THREAD permission");
                            }
                        }
                        catch (InvocationTargetException ite) {
                            if (Printer.debug) {
                                Printer.debug("EventDispatcher.start(): could not got THREAD permission");
                            }
                        }
                        catch (IllegalAccessException iae) {
                            if (!Printer.debug) break block19;
                            Printer.debug("EventDispatcher.start(): could not got THREAD permission");
                        }
                    }
                    this.thread = new Thread(this);
                    this.thread.start();
                }
            } else {
                if (Printer.debug) {
                    Printer.debug("EventDispatcher.start(): no securityPrivilege or jsSecurity==null, not using security");
                }
                this.thread = new Thread(this);
                this.thread.start();
            }
        }
    }

    protected void processEvent(EventInfo eventInfo) {
        if (eventInfo.getEvent() instanceof LineEvent) {
            LineEvent event = (LineEvent)eventInfo.getEvent();
            Vector currentListeners = eventInfo.getListeners();
            int i = 0;
            while (i < currentListeners.size()) {
                ((LineListener)currentListeners.elementAt(i)).update(event);
                ++i;
            }
            return;
        }
        if (eventInfo.getEvent() instanceof MetaMessage) {
            MetaMessage event = (MetaMessage)eventInfo.getEvent();
            Vector currentListeners = eventInfo.getListeners();
            int i = 0;
            while (i < currentListeners.size()) {
                ((MetaEventListener)currentListeners.elementAt(i)).meta(event);
                ++i;
            }
            return;
        }
        if (eventInfo.getEvent() instanceof ShortMessage) {
            ShortMessage event = (ShortMessage)eventInfo.getEvent();
            int status = event.getStatus();
            if (status >> 4 == 11) {
                Vector currentListeners = eventInfo.getListeners();
                int i = 0;
                while (i < currentListeners.size()) {
                    ((ControllerEventListener)currentListeners.elementAt(i)).controlChange(event);
                    ++i;
                }
            }
            return;
        }
        Printer.err("Unknown event type: " + eventInfo.getEvent());
    }

    protected void dispatchEvents() {
        EventInfo eventInfo = null;
        EventDispatcher eventDispatcher = this;
        synchronized (eventDispatcher) {
            try {
                while (!this.done && this.eventQueue.size() == 0) {
                    this.wait();
                }
            }
            catch (InterruptedException e) {
                this.done = true;
                this.notifyAll();
            }
            if (!this.done) {
                eventInfo = (EventInfo)this.eventQueue.elementAt(0);
                this.eventQueue.removeElementAt(0);
            }
        }
        if (eventInfo != null) {
            this.processEvent(eventInfo);
        }
    }

    synchronized void postEvent(EventInfo eventInfo) {
        this.eventQueue.addElement(eventInfo);
        this.notifyAll();
    }

    synchronized void kill() {
        this.done = true;
        this.notifyAll();
    }

    public void run() {
        while (!this.done) {
            this.dispatchEvents();
        }
    }

    void sendAudioEvents(Object event, Vector listeners) {
        this.start();
        Vector currentListeners = (Vector)listeners.clone();
        EventInfo eventInfo = new EventInfo(event, currentListeners);
        this.postEvent(eventInfo);
    }

    static {
        securityPrivilege = true;
        if (Printer.debug) {
            Printer.debug("EventDispatcher.static: securityPrivilege = " + securityPrivilege);
        }
        try {
            jsSecurity = JSSecurityManager.getJSSecurity();
        }
        catch (SecurityException e) {
            if (Printer.debug) {
                Printer.debug("Exception caught: " + e);
            }
            if (Printer.debug) {
                Printer.debug("Setting securityPrivilege to false");
            }
            securityPrivilege = false;
        }
    }

    class EventInfo {
        private Object event;
        private Vector listeners;

        EventInfo(Object event, Vector listeners) {
            this.event = event;
            this.listeners = listeners;
        }

        Object getEvent() {
            return this.event;
        }

        Vector getListeners() {
            return this.listeners;
        }
    }
}

