/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmfsound.imp;

import com.sun.jmfsound.imp.AbstractPlayer;
import com.sun.jmfsound.imp.Printer;
import com.sun.jmfsound.midi.MidiDevice;
import com.sun.jmfsound.midi.MidiUnavailableException;
import com.sun.jmfsound.midi.Synthesizer;

class MixerSynth
extends AbstractPlayer
implements Synthesizer {
    static final MixerSynthInfo info = new MixerSynthInfo();

    MixerSynth() throws MidiUnavailableException {
        super(info);
        if (Printer.trace) {
            Printer.trace(">> MixerSynth CONSTRUCTOR");
        }
        if (Printer.trace) {
            Printer.trace("<< MixerSynth CONSTRUCTOR completed");
        }
    }

    public long getTimeStamp() {
        return -1L;
    }

    public void setTimeStamp(long timeStamp) {
    }

    public void implOpen() throws MidiUnavailableException {
        this.id = this.nCreateSynthesizer();
        if (this.id == 0) {
            throw new MidiUnavailableException("Failed to initialize synthesizer");
        }
        this.openInternalSynth();
        this.connectToInternalSynth();
        if (!this.nStartSynthesizer(this.id)) {
            this.id = 0;
            throw new MidiUnavailableException("Failed to start synthesizer");
        }
        int i = 0;
        while (i < this.channels.length) {
            this.channels[i].setId(this.id);
            ++i;
        }
    }

    private native int nCreateSynthesizer();

    private native boolean nStartSynthesizer(int var1);

    private static class MixerSynthInfo
    extends MidiDevice.Info {
        private static final String name = "Java Sound Synthesizer";
        private static final String vendor = "Sun Microsystems";
        private static final String description = "Software wavetable synthesizer and receiver";
        private static final String version = "Version 1.0";

        private MixerSynthInfo() {
            super(name, vendor, description, version);
        }
    }
}

