/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmfsound.imp;

import com.sun.jmfsound.imp.Printer;
import com.sun.jmfsound.imp.SunCodec;
import com.sun.jmfsound.sampled.AudioFormat;
import com.sun.jmfsound.sampled.AudioInputStream;
import java.io.IOException;
import java.util.Vector;

public class PCMtoPCMCodec
extends SunCodec {
    private static final AudioFormat.Encoding[] inputEncodings = new AudioFormat.Encoding[]{AudioFormat.Encoding.PCM_SIGNED, AudioFormat.Encoding.PCM_UNSIGNED};
    private static final AudioFormat.Encoding[] outputEncodings = new AudioFormat.Encoding[]{AudioFormat.Encoding.PCM_SIGNED, AudioFormat.Encoding.PCM_UNSIGNED};
    private static final int tempBufferSize = 64;
    private byte[] tempBuffer = null;

    public PCMtoPCMCodec() {
        super(inputEncodings, outputEncodings);
    }

    public AudioFormat.Encoding[] getTargetEncodings(AudioFormat sourceFormat) {
        if (sourceFormat.getEncoding().equals(AudioFormat.Encoding.PCM_SIGNED) || sourceFormat.getEncoding().equals(AudioFormat.Encoding.PCM_UNSIGNED)) {
            AudioFormat.Encoding[] encs = new AudioFormat.Encoding[]{AudioFormat.Encoding.PCM_SIGNED, AudioFormat.Encoding.PCM_UNSIGNED};
            return encs;
        }
        return new AudioFormat.Encoding[0];
    }

    public AudioFormat[] getTargetFormats(AudioFormat.Encoding targetEncoding, AudioFormat sourceFormat) {
        AudioFormat[] formats = this.getOutputFormats(sourceFormat);
        Vector<AudioFormat> newFormats = new Vector<AudioFormat>();
        int i = 0;
        while (i < formats.length) {
            if (formats[i].getEncoding().equals(targetEncoding)) {
                newFormats.addElement(formats[i]);
            }
            ++i;
        }
        AudioFormat[] formatArray = new AudioFormat[newFormats.size()];
        int i2 = 0;
        while (i2 < formatArray.length) {
            formatArray[i2] = (AudioFormat)newFormats.elementAt(i2);
            ++i2;
        }
        return formatArray;
    }

    public AudioInputStream getAudioInputStream(AudioFormat.Encoding targetEncoding, AudioInputStream sourceStream) {
        if (this.isConversionSupported(targetEncoding, sourceStream.getFormat())) {
            AudioFormat sourceFormat = sourceStream.getFormat();
            AudioFormat targetFormat = new AudioFormat(targetEncoding, sourceFormat.getSampleRate(), sourceFormat.getSampleSizeInBits(), sourceFormat.getChannels(), sourceFormat.getFrameSize(), sourceFormat.getFrameRate(), sourceFormat.isBigEndian());
            return this.getAudioInputStream(targetFormat, sourceStream);
        }
        throw new IllegalArgumentException("Unsupported conversion: " + sourceStream.getFormat().toString() + " to " + targetEncoding.toString());
    }

    public AudioInputStream getAudioInputStream(AudioFormat targetFormat, AudioInputStream sourceStream) {
        return this.getConvertedStream(targetFormat, sourceStream);
    }

    private AudioInputStream getConvertedStream(AudioFormat outputFormat, AudioInputStream stream) {
        AudioInputStream cs = null;
        AudioFormat inputFormat = stream.getFormat();
        if (inputFormat.matches(outputFormat)) {
            cs = stream;
        } else {
            cs = new PCMtoPCMCodecStream(stream, outputFormat);
            this.tempBuffer = new byte[64];
        }
        return cs;
    }

    private AudioFormat[] getOutputFormats(AudioFormat inputFormat) {
        AudioFormat[] formatArray;
        AudioFormat format;
        Vector<AudioFormat> formats = new Vector<AudioFormat>();
        int sampleSize = inputFormat.getSampleSizeInBits();
        boolean isBigEndian = inputFormat.isBigEndian();
        if (sampleSize == 8) {
            if (inputFormat.getEncoding() == AudioFormat.Encoding.PCM_SIGNED) {
                format = new AudioFormat(AudioFormat.Encoding.PCM_UNSIGNED, inputFormat.getSampleRate(), inputFormat.getSampleSizeInBits(), inputFormat.getChannels(), inputFormat.getFrameSize(), inputFormat.getFrameRate(), false);
                formats.addElement(format);
            }
            if (inputFormat.getEncoding() == AudioFormat.Encoding.PCM_UNSIGNED) {
                format = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, inputFormat.getSampleRate(), inputFormat.getSampleSizeInBits(), inputFormat.getChannels(), inputFormat.getFrameSize(), inputFormat.getFrameRate(), false);
                formats.addElement(format);
            }
        } else if (sampleSize == 16) {
            if (inputFormat.getEncoding() == AudioFormat.Encoding.PCM_SIGNED && isBigEndian) {
                format = new AudioFormat(AudioFormat.Encoding.PCM_UNSIGNED, inputFormat.getSampleRate(), inputFormat.getSampleSizeInBits(), inputFormat.getChannels(), inputFormat.getFrameSize(), inputFormat.getFrameRate(), true);
                formats.addElement(format);
                format = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, inputFormat.getSampleRate(), inputFormat.getSampleSizeInBits(), inputFormat.getChannels(), inputFormat.getFrameSize(), inputFormat.getFrameRate(), false);
                formats.addElement(format);
                format = new AudioFormat(AudioFormat.Encoding.PCM_UNSIGNED, inputFormat.getSampleRate(), inputFormat.getSampleSizeInBits(), inputFormat.getChannels(), inputFormat.getFrameSize(), inputFormat.getFrameRate(), false);
                formats.addElement(format);
            }
            if (inputFormat.getEncoding() == AudioFormat.Encoding.PCM_UNSIGNED && isBigEndian) {
                format = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, inputFormat.getSampleRate(), inputFormat.getSampleSizeInBits(), inputFormat.getChannels(), inputFormat.getFrameSize(), inputFormat.getFrameRate(), true);
                formats.addElement(format);
                format = new AudioFormat(AudioFormat.Encoding.PCM_UNSIGNED, inputFormat.getSampleRate(), inputFormat.getSampleSizeInBits(), inputFormat.getChannels(), inputFormat.getFrameSize(), inputFormat.getFrameRate(), false);
                formats.addElement(format);
                format = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, inputFormat.getSampleRate(), inputFormat.getSampleSizeInBits(), inputFormat.getChannels(), inputFormat.getFrameSize(), inputFormat.getFrameRate(), false);
                formats.addElement(format);
            }
            if (inputFormat.getEncoding() == AudioFormat.Encoding.PCM_SIGNED && !isBigEndian) {
                format = new AudioFormat(AudioFormat.Encoding.PCM_UNSIGNED, inputFormat.getSampleRate(), inputFormat.getSampleSizeInBits(), inputFormat.getChannels(), inputFormat.getFrameSize(), inputFormat.getFrameRate(), false);
                formats.addElement(format);
                format = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, inputFormat.getSampleRate(), inputFormat.getSampleSizeInBits(), inputFormat.getChannels(), inputFormat.getFrameSize(), inputFormat.getFrameRate(), true);
                formats.addElement(format);
                format = new AudioFormat(AudioFormat.Encoding.PCM_UNSIGNED, inputFormat.getSampleRate(), inputFormat.getSampleSizeInBits(), inputFormat.getChannels(), inputFormat.getFrameSize(), inputFormat.getFrameRate(), true);
                formats.addElement(format);
            }
            if (inputFormat.getEncoding() == AudioFormat.Encoding.PCM_UNSIGNED && !isBigEndian) {
                format = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, inputFormat.getSampleRate(), inputFormat.getSampleSizeInBits(), inputFormat.getChannels(), inputFormat.getFrameSize(), inputFormat.getFrameRate(), false);
                formats.addElement(format);
                format = new AudioFormat(AudioFormat.Encoding.PCM_UNSIGNED, inputFormat.getSampleRate(), inputFormat.getSampleSizeInBits(), inputFormat.getChannels(), inputFormat.getFrameSize(), inputFormat.getFrameRate(), true);
                formats.addElement(format);
                format = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, inputFormat.getSampleRate(), inputFormat.getSampleSizeInBits(), inputFormat.getChannels(), inputFormat.getFrameSize(), inputFormat.getFrameRate(), true);
                formats.addElement(format);
            }
        }
        Vector<AudioFormat> vector = formats;
        synchronized (vector) {
            formatArray = new AudioFormat[formats.size()];
            int i = 0;
            while (i < formatArray.length) {
                formatArray[i] = (AudioFormat)formats.elementAt(i);
                ++i;
            }
        }
        return formatArray;
    }

    class PCMtoPCMCodecStream
    extends AudioInputStream {
        private final int PCM_SWITCH_SIGNED_8BIT = 1;
        private final int PCM_SWITCH_ENDIAN = 2;
        private final int PCM_SWITCH_SIGNED_LE = 3;
        private final int PCM_SWITCH_SIGNED_BE = 4;
        private final int PCM_UNSIGNED_LE2SIGNED_BE = 5;
        private final int PCM_SIGNED_LE2UNSIGNED_BE = 6;
        private final int PCM_UNSIGNED_BE2SIGNED_LE = 7;
        private final int PCM_SIGNED_BE2UNSIGNED_LE = 8;
        private int sampleSizeInBytes = 0;
        private int conversionType = 0;

        PCMtoPCMCodecStream(AudioInputStream stream, AudioFormat outputFormat) {
            super(stream, outputFormat, -1L);
            int sampleSizeInBits = 0;
            AudioFormat.Encoding inputEncoding = null;
            AudioFormat.Encoding outputEncoding = null;
            AudioFormat inputFormat = stream.getFormat();
            if (!PCMtoPCMCodec.this.isConversionSupported(inputFormat, outputFormat)) {
                throw new IllegalArgumentException("Unsupported conversion: " + inputFormat.toString() + " to " + outputFormat.toString());
            }
            inputEncoding = inputFormat.getEncoding();
            outputEncoding = outputFormat.getEncoding();
            boolean inputIsBigEndian = inputFormat.isBigEndian();
            boolean outputIsBigEndian = outputFormat.isBigEndian();
            sampleSizeInBits = inputFormat.getSampleSizeInBits();
            this.sampleSizeInBytes = sampleSizeInBits / 8;
            if (sampleSizeInBits == 8) {
                if (inputEncoding == AudioFormat.Encoding.PCM_UNSIGNED && outputEncoding == AudioFormat.Encoding.PCM_SIGNED) {
                    this.conversionType = 1;
                    if (Printer.debug) {
                        Printer.debug("PCMtoPCMCodecStream: conversionType = PCM_SWITCH_SIGNED_8BIT");
                    }
                } else if (inputEncoding == AudioFormat.Encoding.PCM_SIGNED && outputEncoding == AudioFormat.Encoding.PCM_UNSIGNED) {
                    this.conversionType = 1;
                    if (Printer.debug) {
                        Printer.debug("PCMtoPCMCodecStream: conversionType = PCM_SWITCH_SIGNED_8BIT");
                    }
                }
            } else if (inputEncoding == outputEncoding && inputIsBigEndian != outputIsBigEndian) {
                this.conversionType = 2;
                if (Printer.debug) {
                    Printer.debug("PCMtoPCMCodecStream: conversionType = PCM_SWITCH_ENDIAN");
                }
            } else if (inputEncoding == AudioFormat.Encoding.PCM_UNSIGNED && !inputIsBigEndian && outputEncoding == AudioFormat.Encoding.PCM_SIGNED && outputIsBigEndian) {
                this.conversionType = 5;
                if (Printer.debug) {
                    Printer.debug("PCMtoPCMCodecStream: conversionType = PCM_UNSIGNED_LE2SIGNED_BE");
                }
            } else if (inputEncoding == AudioFormat.Encoding.PCM_SIGNED && !inputIsBigEndian && outputEncoding == AudioFormat.Encoding.PCM_UNSIGNED && outputIsBigEndian) {
                this.conversionType = 6;
                if (Printer.debug) {
                    Printer.debug("PCMtoPCMCodecStream: conversionType = PCM_SIGNED_LE2UNSIGNED_BE");
                }
            } else if (inputEncoding == AudioFormat.Encoding.PCM_UNSIGNED && inputIsBigEndian && outputEncoding == AudioFormat.Encoding.PCM_SIGNED && !outputIsBigEndian) {
                this.conversionType = 7;
                if (Printer.debug) {
                    Printer.debug("PCMtoPCMCodecStream: conversionType = PCM_UNSIGNED_BE2SIGNED_LE");
                }
            } else if (inputEncoding == AudioFormat.Encoding.PCM_SIGNED && inputIsBigEndian && outputEncoding == AudioFormat.Encoding.PCM_UNSIGNED && !outputIsBigEndian) {
                this.conversionType = 8;
                if (Printer.debug) {
                    Printer.debug("PCMtoPCMCodecStream: conversionType = PCM_SIGNED_BE2UNSIGNED_LE");
                }
            }
            this.frameSize = inputFormat.getFrameSize();
            if (this.frameSize == -1) {
                this.frameSize = 1;
            }
            this.frameLength = stream instanceof AudioInputStream ? stream.getFrameLength() : -1L;
            this.framePos = 0L;
        }

        public int read() throws IOException {
            if (this.frameSize == 1) {
                if (this.conversionType == 1) {
                    int temp = super.read();
                    if (temp < 0) {
                        return temp;
                    }
                    byte tempbyte = (byte)(temp & 0xF);
                    tempbyte = tempbyte >= 0 ? (byte)(0x80 | tempbyte) : (byte)(0x7F & tempbyte);
                    temp = tempbyte & 0xF;
                    ++this.framePos;
                    return temp;
                }
                throw new IOException("cannot read a single byte if frame size > 1");
            }
            throw new IOException("cannot read a single byte if frame size > 1");
        }

        public int read(byte[] b) throws IOException {
            return this.read(b, 0, b.length);
        }

        public int read(byte[] b, int off, int len) throws IOException {
            int readCount;
            if (len % this.frameSize != 0) {
                len -= len % this.frameSize;
            }
            if (this.frameLength != -1L && (long)(len / this.frameSize) > this.frameLength - this.framePos) {
                len = (int)(this.frameLength - this.framePos) * this.frameSize;
            }
            if ((readCount = super.read(b, off, len)) < 0) {
                return readCount;
            }
            switch (this.conversionType) {
                case 1: {
                    this.switchSigned8bit(b, off, len, readCount);
                    break;
                }
                case 2: {
                    this.switchEndian(b, off, len, readCount);
                    break;
                }
                case 3: {
                    this.switchSignedLE(b, off, len, readCount);
                    break;
                }
                case 4: {
                    this.switchSignedBE(b, off, len, readCount);
                    break;
                }
                case 5: 
                case 6: {
                    this.switchSignedLE(b, off, len, readCount);
                    this.switchEndian(b, off, len, readCount);
                    break;
                }
                case 7: 
                case 8: {
                    this.switchSignedBE(b, off, len, readCount);
                    this.switchEndian(b, off, len, readCount);
                    break;
                }
            }
            this.framePos += (long)(readCount / this.frameSize);
            return readCount;
        }

        private void switchSigned8bit(byte[] b, int off, int len, int readCount) {
            int i = off;
            while (i < off + readCount) {
                b[i] = b[i] >= 0 ? (byte)(0x80 | b[i]) : (byte)(0x7F & b[i]);
                ++i;
            }
        }

        private void switchSignedBE(byte[] b, int off, int len, int readCount) {
            int i = off;
            while (i < off + readCount) {
                b[i] = b[i] >= 0 ? (byte)(0x80 | b[i]) : (byte)(0x7F & b[i]);
                i += this.sampleSizeInBytes;
            }
        }

        private void switchSignedLE(byte[] b, int off, int len, int readCount) {
            int i = off + this.sampleSizeInBytes - 1;
            while (i < off + readCount) {
                b[i] = b[i] >= 0 ? (byte)(0x80 | b[i]) : (byte)(0x7F & b[i]);
                i += this.sampleSizeInBytes;
            }
        }

        private void switchEndian(byte[] b, int off, int len, int readCount) {
            if (this.sampleSizeInBytes == 2) {
                int i = off;
                while (i < off + readCount) {
                    byte temp = b[i];
                    b[i] = b[i + 1];
                    b[i + 1] = temp;
                    i += this.sampleSizeInBytes;
                }
            }
        }
    }
}

