/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmfsound.imp;

import com.sun.jmfsound.imp.JSSecurity;
import com.sun.jmfsound.imp.JSSecurityManager;
import com.sun.jmfsound.imp.Printer;
import com.sun.jmfsound.sampled.AudioFileFormat;
import com.sun.jmfsound.sampled.AudioInputStream;
import com.sun.jmfsound.sampled.spi.AudioFileWriter;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.lang.reflect.Method;

abstract class SunFileWriter
extends AudioFileWriter {
    private static SunFileWriter[] fileWriters;
    protected static final int bufferSize = 16384;
    protected static final int bisBufferSize = 4096;
    private static final String[] fileWriterClassNames;
    final AudioFileFormat.Type[] types;
    private static JSSecurity jsSecurity;
    private static boolean securityPrivilege;
    private static Method[] m;
    private static Class[] cl;
    private static Object[][] args;

    SunFileWriter(AudioFileFormat.Type[] types) {
        this.types = types;
    }

    public AudioFileFormat.Type[] getAudioFileTypes() {
        AudioFileFormat.Type[] localArray = new AudioFileFormat.Type[this.types.length];
        System.arraycopy(this.types, 0, localArray, 0, this.types.length);
        return localArray;
    }

    public abstract AudioFileFormat.Type[] getAudioFileTypes(AudioInputStream var1);

    public abstract int write(AudioInputStream var1, AudioFileFormat.Type var2, OutputStream var3) throws IOException;

    public abstract int write(AudioInputStream var1, AudioFileFormat.Type var2, File var3) throws IOException;

    static int getNumFileWriters() {
        return fileWriters.length;
    }

    static SunFileWriter getFileWriter(int index) {
        SunFileWriter[] sunFileWriterArray = fileWriters;
        synchronized (sunFileWriterArray) {
            block10: {
                try {
                    if (fileWriters[index] == null) {
                        Class<?> fileWriterClass = Class.forName(fileWriterClassNames[index]);
                        SunFileWriter.fileWriters[index] = (SunFileWriter)fileWriterClass.newInstance();
                    }
                }
                catch (ClassNotFoundException e) {
                    if (Printer.err) {
                        Printer.err("ClassNotFoundException: " + e);
                    }
                }
                catch (InstantiationException e2) {
                    if (Printer.err) {
                        Printer.err("InstantiationException: " + e2);
                    }
                }
                catch (IllegalAccessException e3) {
                    if (!Printer.err) break block10;
                    Printer.err("IllegalAccessException: " + e3);
                }
            }
        }
        return fileWriters[index];
    }

    protected static RandomAccessFile openRandomAccessFile(File file) throws IOException {
        RandomAccessFile raf;
        block9: {
            raf = null;
            if (!securityPrivilege) {
                try {
                    jsSecurity = JSSecurityManager.getJSSecurity();
                    securityPrivilege = true;
                }
                catch (SecurityException e) {
                    if (!Printer.err) break block9;
                    Printer.err("SunParser.java: Security Exception: " + e);
                }
            }
        }
        if (securityPrivilege && jsSecurity != null) {
            if (jsSecurity.getName().startsWith("JDK12")) {
                raf = new RandomAccessFile(file, "rw");
            } else {
                block10: {
                    try {
                        jsSecurity.requestPermission(m, cl, args, 2);
                        m[0].invoke((Object)cl[0], args[0]);
                        jsSecurity.requestPermission(m, cl, args, 4);
                        m[0].invoke((Object)cl[0], args[0]);
                    }
                    catch (Exception e) {
                        if (!Printer.err) break block10;
                        Printer.err("Unable to get file privileges: " + e);
                    }
                }
                raf = new RandomAccessFile(file, "rw");
            }
        } else {
            raf = new RandomAccessFile(file, "rw");
        }
        return raf;
    }

    protected int rllong(DataInputStream dis) throws IOException {
        int i = 0;
        i = dis.readInt();
        int b1 = (i & 0xFF) << 24;
        int b2 = (i & 0xFF00) << 8;
        int b3 = (i & 0xFF0000) >> 8;
        int b4 = (i & 0xFF000000) >>> 24;
        i = b1 | b2 | b3 | b4;
        return i;
    }

    protected int big2little(int i) {
        int b1 = (i & 0xFF) << 24;
        int b2 = (i & 0xFF00) << 8;
        int b3 = (i & 0xFF0000) >> 8;
        int b4 = (i & 0xFF000000) >>> 24;
        i = b1 | b2 | b3 | b4;
        return i;
    }

    protected short rlshort(DataInputStream dis) throws IOException {
        short s = 0;
        s = dis.readShort();
        short high = (short)((s & 0xFF) << 8);
        short low = (short)((s & 0xFF00) >>> 8);
        s = (short)(high | low);
        return s;
    }

    protected short big2littleShort(short i) {
        short high = (short)((i & 0xFF) << 8);
        short low = (short)((i & 0xFF00) >>> 8);
        i = (short)(high | low);
        return i;
    }

    static {
        fileWriterClassNames = new String[]{"com.sun.jmfsound.imp.AuFileWriter", "com.sun.jmfsound.imp.WaveFileWriter", "com.sun.jmfsound.imp.AiffFileWriter"};
        fileWriters = new SunFileWriter[fileWriterClassNames.length];
        jsSecurity = null;
        securityPrivilege = false;
        m = new Method[1];
        cl = new Class[1];
        args = new Object[1][0];
    }
}

