/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmfsound.midi;

import com.sun.jmfsound.midi.InvalidMidiDataException;
import com.sun.jmfsound.midi.MidiDevice;
import com.sun.jmfsound.midi.MidiFileFormat;
import com.sun.jmfsound.midi.MidiUnavailableException;
import com.sun.jmfsound.midi.Receiver;
import com.sun.jmfsound.midi.Sequence;
import com.sun.jmfsound.midi.Sequencer;
import com.sun.jmfsound.midi.Soundbank;
import com.sun.jmfsound.midi.Synthesizer;
import com.sun.jmfsound.midi.Transmitter;
import com.sun.jmfsound.midi.spi.MidiDeviceProvider;
import com.sun.jmfsound.midi.spi.MidiFileReader;
import com.sun.jmfsound.midi.spi.MidiFileWriter;
import com.sun.jmfsound.midi.spi.SoundbankReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Vector;

public class MidiSystem {
    private static final String defaultServicesClassName = "com.sun.jmfsound.imp.DefaultServices";
    private static final String jdk13ServicesClassName = "com.sun.jmfsound.imp.JDK13Services";
    private static final String servicesMethodName = "getProviders";
    private static final Class[] servicesParamTypes = new Class[]{class$java$lang$String == null ? (class$java$lang$String = MidiSystem.class$("java.lang.String")) : class$java$lang$String};
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$com$sun$jmfsound$midi$MidiDevice;
    static /* synthetic */ Class class$com$sun$jmfsound$midi$Receiver;
    static /* synthetic */ Class class$com$sun$jmfsound$midi$Transmitter;
    static /* synthetic */ Class class$com$sun$jmfsound$midi$Synthesizer;
    static /* synthetic */ Class class$com$sun$jmfsound$midi$Sequencer;

    private MidiSystem() {
    }

    public static MidiDevice.Info[] getMidiDeviceInfo() {
        return MidiSystem.getGenericDeviceInfo(class$com$sun$jmfsound$midi$MidiDevice == null ? (class$com$sun$jmfsound$midi$MidiDevice = MidiSystem.class$("com.sun.jmfsound.midi.MidiDevice")) : class$com$sun$jmfsound$midi$MidiDevice);
    }

    public static MidiDevice getMidiDevice(MidiDevice.Info info) throws MidiUnavailableException {
        return (MidiDevice)MidiSystem.getGenericDevice(null, info);
    }

    public static Receiver getReceiver() throws MidiUnavailableException {
        return ((MidiDevice)MidiSystem.getGenericDevice(class$com$sun$jmfsound$midi$Receiver == null ? (class$com$sun$jmfsound$midi$Receiver = MidiSystem.class$("com.sun.jmfsound.midi.Receiver")) : class$com$sun$jmfsound$midi$Receiver, null)).getReceiver();
    }

    public static Transmitter getTransmitter() throws MidiUnavailableException {
        return ((MidiDevice)MidiSystem.getGenericDevice(class$com$sun$jmfsound$midi$Transmitter == null ? (class$com$sun$jmfsound$midi$Transmitter = MidiSystem.class$("com.sun.jmfsound.midi.Transmitter")) : class$com$sun$jmfsound$midi$Transmitter, null)).getTransmitter();
    }

    public static Synthesizer getSynthesizer() throws MidiUnavailableException {
        return (Synthesizer)MidiSystem.getGenericDevice(class$com$sun$jmfsound$midi$Synthesizer == null ? (class$com$sun$jmfsound$midi$Synthesizer = MidiSystem.class$("com.sun.jmfsound.midi.Synthesizer")) : class$com$sun$jmfsound$midi$Synthesizer, null);
    }

    public static Sequencer getSequencer() throws MidiUnavailableException {
        return (Sequencer)MidiSystem.getGenericDevice(class$com$sun$jmfsound$midi$Sequencer == null ? (class$com$sun$jmfsound$midi$Sequencer = MidiSystem.class$("com.sun.jmfsound.midi.Sequencer")) : class$com$sun$jmfsound$midi$Sequencer, null);
    }

    public static Soundbank getSoundbank(InputStream stream) throws InvalidMidiDataException, IOException {
        Vector v1 = new Vector();
        SoundbankReader sp = null;
        Soundbank s = null;
        v1 = MidiSystem.getSoundbankReaders();
        int i = 0;
        while (i < v1.size()) {
            sp = (SoundbankReader)v1.elementAt(i);
            s = sp.getSoundbank(stream);
            if (s != null) {
                return s;
            }
            ++i;
        }
        throw new InvalidMidiDataException("cannot get soundbank from stream");
    }

    public static Soundbank getSoundbank(URL url) throws InvalidMidiDataException, IOException {
        Vector v1 = new Vector();
        SoundbankReader sp = null;
        Soundbank s = null;
        v1 = MidiSystem.getSoundbankReaders();
        int i = 0;
        while (i < v1.size()) {
            sp = (SoundbankReader)v1.elementAt(i);
            s = sp.getSoundbank(url);
            if (s != null) {
                return s;
            }
            ++i;
        }
        throw new InvalidMidiDataException("cannot get soundbank from stream");
    }

    public static Soundbank getSoundbank(File file) throws InvalidMidiDataException, IOException {
        FileInputStream fis = new FileInputStream(file);
        return MidiSystem.getSoundbank(fis);
    }

    public static MidiFileFormat getMidiFileFormat(InputStream stream) throws InvalidMidiDataException, IOException {
        MidiFileReader[] providers = MidiSystem.getMidiFileReaders();
        MidiFileFormat format = null;
        int i = 0;
        while (i < providers.length) {
            try {
                format = providers[i].getMidiFileFormat(stream);
                break;
            }
            catch (InvalidMidiDataException e) {
                ++i;
            }
        }
        if (format == null) {
            throw new InvalidMidiDataException("input stream is not a supported file type");
        }
        return format;
    }

    public static MidiFileFormat getMidiFileFormat(URL url) throws InvalidMidiDataException, IOException {
        MidiFileReader[] providers = MidiSystem.getMidiFileReaders();
        MidiFileFormat format = null;
        int i = 0;
        while (i < providers.length) {
            try {
                format = providers[i].getMidiFileFormat(url);
                break;
            }
            catch (InvalidMidiDataException e) {
                ++i;
            }
        }
        if (format == null) {
            throw new InvalidMidiDataException("url is not a supported file type");
        }
        return format;
    }

    public static MidiFileFormat getMidiFileFormat(File file) throws InvalidMidiDataException, IOException {
        MidiFileReader[] providers = MidiSystem.getMidiFileReaders();
        MidiFileFormat format = null;
        int i = 0;
        while (i < providers.length) {
            try {
                format = providers[i].getMidiFileFormat(file);
                break;
            }
            catch (InvalidMidiDataException e) {
                ++i;
            }
        }
        if (format == null) {
            throw new InvalidMidiDataException("file is not a supported file type");
        }
        return format;
    }

    public static Sequence getSequence(InputStream stream) throws InvalidMidiDataException, IOException {
        MidiFileReader[] providers = MidiSystem.getMidiFileReaders();
        Sequence sequence = null;
        int i = 0;
        while (i < providers.length) {
            try {
                sequence = providers[i].getSequence(stream);
                break;
            }
            catch (InvalidMidiDataException e) {
                ++i;
            }
        }
        if (sequence == null) {
            throw new InvalidMidiDataException("could not get sequence from input stream");
        }
        return sequence;
    }

    public static Sequence getSequence(URL url) throws InvalidMidiDataException, IOException {
        MidiFileReader[] providers = MidiSystem.getMidiFileReaders();
        Sequence sequence = null;
        int i = 0;
        while (i < providers.length) {
            try {
                sequence = providers[i].getSequence(url);
                break;
            }
            catch (InvalidMidiDataException e) {
                ++i;
            }
        }
        if (sequence == null) {
            throw new InvalidMidiDataException("could not get sequence from URL");
        }
        return sequence;
    }

    public static Sequence getSequence(File file) throws InvalidMidiDataException, IOException {
        MidiFileReader[] providers = MidiSystem.getMidiFileReaders();
        Sequence sequence = null;
        int i = 0;
        while (i < providers.length) {
            try {
                sequence = providers[i].getSequence(file);
                break;
            }
            catch (InvalidMidiDataException e) {
                ++i;
            }
        }
        if (sequence == null) {
            throw new InvalidMidiDataException("could not get sequence from file");
        }
        return sequence;
    }

    public static int[] getMidiFileTypes() {
        MidiFileWriter[] providers = MidiSystem.getMidiFileWriters();
        Vector<int[]> allTypes = new Vector<int[]>();
        int size = 0;
        int index = 0;
        int[] types = null;
        int i = 0;
        while (i < providers.length) {
            types = providers[i].getMidiFileTypes();
            size += types.length;
            allTypes.addElement(types);
            ++i;
        }
        int[] types2 = new int[size];
        int i2 = 0;
        while (i2 < allTypes.size()) {
            types = (int[])allTypes.elementAt(i2);
            int j = 0;
            while (j < types.length) {
                types2[index++] = types[j];
                ++j;
            }
            ++i2;
        }
        return types2;
    }

    public static boolean isFileTypeSupported(int fileType) {
        MidiFileWriter[] providers = MidiSystem.getMidiFileWriters();
        int i = 0;
        while (i < providers.length) {
            if (providers[i].isFileTypeSupported(fileType)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static int[] getMidiFileTypes(Sequence sequence) {
        MidiFileWriter[] providers = MidiSystem.getMidiFileWriters();
        int[][] types = new int[providers.length][];
        int[] returnTypes = null;
        int numTypes = 0;
        int index = 0;
        int i = 0;
        while (i < providers.length) {
            types[i] = providers[i].getMidiFileTypes(sequence);
            numTypes += types[i].length;
            ++i;
        }
        returnTypes = new int[numTypes];
        int i2 = 0;
        while (i2 < providers.length) {
            int j = 0;
            while (j < types[i2].length) {
                returnTypes[index] = types[i2][j];
                ++index;
                ++j;
            }
            ++i2;
        }
        return returnTypes;
    }

    public static boolean isFileTypeSupported(int fileType, Sequence sequence) {
        MidiFileWriter[] providers = MidiSystem.getMidiFileWriters();
        int i = 0;
        while (i < providers.length) {
            if (providers[i].isFileTypeSupported(fileType, sequence)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static int write(Sequence in, int fileType, OutputStream out) throws IOException {
        MidiFileWriter[] providers = MidiSystem.getMidiFileWriters();
        int bytesWritten = 0;
        int i = 0;
        while (i < providers.length) {
            if (providers[i].isFileTypeSupported(fileType, in)) {
                bytesWritten = providers[i].write(in, fileType, out);
                break;
            }
            ++i;
        }
        return bytesWritten;
    }

    public static int write(Sequence in, int type, File out) throws IOException {
        MidiFileWriter[] providers = MidiSystem.getMidiFileWriters();
        int bytesWritten = 0;
        int i = 0;
        while (i < providers.length) {
            if (providers[i].isFileTypeSupported(type, in)) {
                bytesWritten = providers[i].write(in, type, out);
                break;
            }
            ++i;
        }
        return bytesWritten;
    }

    private static synchronized boolean isA(Class testClass, Class targetClass) {
        return targetClass.isAssignableFrom(testClass);
    }

    private static Vector getMidiDeviceProviders() {
        Vector providers = null;
        try {
            Class.forName("sun.misc.Service");
            providers = MidiSystem.getJDK13Services("com.sun.jmfsound.midi.spi.MidiDeviceProvider");
        }
        catch (Exception e) {
            providers = MidiSystem.getDefaultServices("com.sun.jmfsound.midi.spi.MidiDeviceProvider");
        }
        return providers;
    }

    private static Vector getSoundbankReaders() {
        Vector providers = null;
        try {
            Class.forName("sun.misc.Service");
            providers = MidiSystem.getJDK13Services("com.sun.jmfsound.midi.spi.SoundbankReader");
        }
        catch (Exception e) {
            providers = MidiSystem.getDefaultServices("com.sun.jmfsound.midi.spi.SoundbankReader");
        }
        return providers;
    }

    private static MidiFileWriter[] getMidiFileWriters() {
        Vector v = new Vector();
        try {
            Class.forName("sun.misc.Service");
            v = MidiSystem.getJDK13Services("com.sun.jmfsound.midi.spi.MidiFileWriter");
        }
        catch (Exception e) {
            v = MidiSystem.getDefaultServices("com.sun.jmfsound.midi.spi.MidiFileWriter");
        }
        MidiFileWriter[] varray = new MidiFileWriter[v.size()];
        int i = 0;
        while (i < varray.length) {
            varray[i] = (MidiFileWriter)v.elementAt(i);
            ++i;
        }
        return varray;
    }

    private static MidiFileReader[] getMidiFileReaders() {
        Vector v = new Vector();
        try {
            Class.forName("sun.misc.Service");
            v = MidiSystem.getJDK13Services("com.sun.jmfsound.midi.spi.MidiFileReader");
        }
        catch (Exception e) {
            v = MidiSystem.getDefaultServices("com.sun.jmfsound.midi.spi.MidiFileReader");
        }
        MidiFileReader[] varray = new MidiFileReader[v.size()];
        int i = 0;
        while (i < varray.length) {
            varray[i] = (MidiFileReader)v.elementAt(i);
            ++i;
        }
        return varray;
    }

    private static MidiDevice.Info[] getGenericDeviceInfo(Class deviceClass) {
        Vector<MidiDevice.Info> v = new Vector<MidiDevice.Info>();
        Vector v1 = MidiSystem.getMidiDeviceProviders();
        int i = 0;
        while (i < v1.size()) {
            MidiDevice.Info[] tmpinfo = ((MidiDeviceProvider)v1.elementAt(i)).getDeviceInfo();
            int j = 0;
            while (j < tmpinfo.length) {
                MidiDevice device = ((MidiDeviceProvider)v1.elementAt(i)).getDevice(tmpinfo[j]);
                if (MidiSystem.isA(deviceClass, class$com$sun$jmfsound$midi$Receiver == null ? MidiSystem.class$("com.sun.jmfsound.midi.Receiver") : class$com$sun$jmfsound$midi$Receiver)) {
                    if (device.getMaxReceivers() != 0) {
                        v.addElement(tmpinfo[j]);
                    }
                } else if (MidiSystem.isA(deviceClass, class$com$sun$jmfsound$midi$Transmitter == null ? MidiSystem.class$("com.sun.jmfsound.midi.Transmitter") : class$com$sun$jmfsound$midi$Transmitter)) {
                    if (device.getMaxTransmitters() != 0) {
                        v.addElement(tmpinfo[j]);
                    }
                } else if (deviceClass.isInstance(device)) {
                    v.addElement(tmpinfo[j]);
                }
                ++j;
            }
            ++i;
        }
        MidiDevice.Info[] varray = new MidiDevice.Info[v.size()];
        i = 0;
        while (i < varray.length) {
            varray[i] = (MidiDevice.Info)v.elementAt(i);
            ++i;
        }
        return varray;
    }

    private static Object getGenericDevice(Class deviceClass, MidiDevice.Info info) {
        Object s = null;
        MidiDevice.Info[] tmpinfo = null;
        Vector v1 = new Vector();
        v1 = MidiSystem.getMidiDeviceProviders();
        int i = 0;
        while (i < v1.size()) {
            MidiDevice device;
            int j;
            tmpinfo = ((MidiDeviceProvider)v1.elementAt(i)).getDeviceInfo();
            if (info == null) {
                j = 0;
                while (j < tmpinfo.length) {
                    device = ((MidiDeviceProvider)v1.elementAt(i)).getDevice(tmpinfo[j]);
                    if (MidiSystem.isA(deviceClass, class$com$sun$jmfsound$midi$Receiver == null ? MidiSystem.class$("com.sun.jmfsound.midi.Receiver") : class$com$sun$jmfsound$midi$Receiver)) {
                        if (device.getMaxReceivers() != 0) {
                            return device;
                        }
                    } else {
                        Class clazz = class$com$sun$jmfsound$midi$Transmitter == null ? MidiSystem.class$("com.sun.jmfsound.midi.Transmitter") : class$com$sun$jmfsound$midi$Transmitter;
                        if (MidiSystem.isA(deviceClass, clazz) ? device.getMaxTransmitters() != 0 : deviceClass.isInstance(device)) {
                            return device;
                        }
                    }
                    ++j;
                }
            } else {
                j = 0;
                while (j < tmpinfo.length) {
                    if (tmpinfo[j].equals(info)) {
                        device = ((MidiDeviceProvider)v1.elementAt(i)).getDevice(tmpinfo[j]);
                        if (deviceClass == null) {
                            return device;
                        }
                        if (MidiSystem.isA(deviceClass, class$com$sun$jmfsound$midi$Receiver == null ? MidiSystem.class$("com.sun.jmfsound.midi.Receiver") : class$com$sun$jmfsound$midi$Receiver) ? device.getMaxReceivers() != 0 : MidiSystem.isA(deviceClass, class$com$sun$jmfsound$midi$Transmitter == null ? MidiSystem.class$("com.sun.jmfsound.midi.Transmitter") : class$com$sun$jmfsound$midi$Transmitter) && device.getMaxTransmitters() != 0) {
                            return device;
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
        throw new IllegalArgumentException("Requested device not installed: " + info);
    }

    private static Vector getJDK13Services(String serviceName) {
        Vector v = null;
        try {
            Class<?> jdk13Services = Class.forName(jdk13ServicesClassName);
            Method m = jdk13Services.getMethod(servicesMethodName, servicesParamTypes);
            Object[] arguments = new Object[]{serviceName};
            v = (Vector)m.invoke(jdk13Services, arguments);
        }
        catch (InvocationTargetException e1) {
            v = new Vector();
        }
        catch (ClassNotFoundException e2) {
            v = new Vector();
        }
        catch (IllegalAccessException e3) {
            v = new Vector();
        }
        catch (NoSuchMethodException e4) {
            v = new Vector();
        }
        return v;
    }

    private static Vector getDefaultServices(String serviceName) {
        Vector v = null;
        try {
            Class<?> defaultServices = Class.forName(defaultServicesClassName);
            Method m = defaultServices.getMethod(servicesMethodName, servicesParamTypes);
            Object[] arguments = new Object[]{serviceName};
            v = (Vector)m.invoke(defaultServices, arguments);
        }
        catch (InvocationTargetException e1) {
            v = new Vector();
        }
        catch (ClassNotFoundException e2) {
            v = new Vector();
        }
        catch (IllegalAccessException e3) {
            v = new Vector();
        }
        catch (NoSuchMethodException e4) {
            v = new Vector();
        }
        return v;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

