/*
 * File:     Constants.java
 * Project:  MPI Linguistic Application
 * Date:     03 April 2006
 *
 * Copyright (C) 2001-2006  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package mpi.eudico.client.annotator;

import java.awt.Color;
import java.awt.Font;


/**
 * DOCUMENT ME!
 * $Id: Constants.java,v 1.3 2006/01/12 17:13:07 hasloe Exp $
 * @author $Author: hasloe $
 * @version $Revision: 1.3 $
 */
public class Constants {
    /** Holds value of property DOCUMENT ME! */
    public static String USERHOME = System.getProperty("user.home");

    /** Holds value of property DOCUMENT ME! */
    public static String FILESEPARATOR = System.getProperty("file.separator");

    /** Holds value of property DOCUMENT ME! */
    public static String STRPROPERTIESFILE = USERHOME + FILESEPARATOR +
        ".elan.config";

    /** Holds value of property DOCUMENT ME! */
    public static String ELAN_DATA_DIR = USERHOME + FILESEPARATOR +
        ".elan_data";

    /** Holds value of property DOCUMENT ME! */
    public static Color DEFAULTBACKGROUNDCOLOR = new Color(230, 230, 230);

    /** Holds value of property DOCUMENT ME! */
    public static Color DEFAULTFOREGROUNDCOLOR = Color.black;

    /** Holds value of property DOCUMENT ME! */
    public static Color SELECTIONCOLOR = new Color(204, 204, 255);

    /** Holds value of property DOCUMENT ME! */
    public static Color CROSSHAIRCOLOR = Color.red;

    /** Holds value of property DOCUMENT ME! */
    public static Color ACTIVEANNOTATIONCOLOR = Color.blue;

    /** Holds value of property DOCUMENT ME! */
    public static Color MEDIAPLAYERCONTROLSLIDERSELECTIONCOLOR = Color.gray;

    /** Holds value of property DOCUMENT ME! */
    public static Color MEDIAPLAYERCONTROLSLIDERCROSSHAIRCOLOR = Color.red.darker();

    /** Holds value of property DOCUMENT ME! */
    public static Color SIGNALSTEREOBLENDEDCOLOR1 = Color.green;

    /** Holds value of property DOCUMENT ME! */
    public static Color SIGNALSTEREOBLENDEDCOLOR2 = Color.blue;

    /** Holds value of property DOCUMENT ME! */
    public static Color SIGNALCHANNELCOLOR = new Color(224, 224, 224);

    /** Holds value of property DOCUMENT ME! */
    public static Color SHAREDCOLOR1 = Color.orange;

    /** Holds value of property DOCUMENT ME! */
    public static Color SHAREDCOLOR2 = Color.yellow;

    /** Holds value of property DOCUMENT ME! */
    public static Color SHAREDCOLOR3 = Color.gray;

    /** Holds value of property DOCUMENT ME! */
    public static Color SHAREDCOLOR4 = Color.white;

    /** Holds value of property DOCUMENT ME! */
    public static Color ACTIVETIERCOLOR = new Color(230, 210, 210);

    /** Holds value of property DOCUMENT ME! */
    public static Font DEFAULTFONT = new Font("Arial Unicode MS", Font.PLAIN, 12);

    /** Holds value of property DOCUMENT ME! */
    public static Font SMALLFONT = new Font("Arial Unicode MS", Font.PLAIN, 10);

    /** Holds value of property DOCUMENT ME! */
    public static final int SCROLLMIN = 0;

    /** Holds value of property DOCUMENT ME! */
    public static final int SCROLLINCREMENT = 1;
    public static final int COMBOBOX_VISIBLE_ROWS = 20;

    // backup interval constants

    /** Holds value of property DOCUMENT ME! */
    public static final Integer BACKUP_NEVER = new Integer(0);

    /** Holds value of property DOCUMENT ME! */
    public static final Integer BACKUP_5 = new Integer(300000);

    /** Holds value of property DOCUMENT ME! */
    public static final Integer BACKUP_10 = new Integer(600000);

    /** Holds value of property DOCUMENT ME! */
    public static final Integer BACKUP_20 = new Integer(1200000);

    /** Holds value of property DOCUMENT ME! */
    public static final Integer BACKUP_30 = new Integer(1800000);

    /** font sizes available in several viewers */
    public static final int[] FONT_SIZES = new int[] {
            8, 9, 10, 12, 14, 16, 18, 24, 36
        };

    // time format constants

    /** the hour/minutes/seconds/milliseconds format */

    //public static final int HHMMSSMS = 0;

    /** the seconds/milliseconds format */

    //public static final int SSMS = 1;

    /** the pure milliseconds format */

    //public static final int MS = 2;

    /** the frame number format */

    //public static final int HHMMSSFF = 3;
}
