/*
 * File:     MediaPlayerUser.java
 * Project:  MPI Linguistic Application
 * Date:     03 April 2006
 *
 * Copyright (C) 2001-2006  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package mpi.eudico.client.annotator;

import mpi.eudico.client.annotator.player.*;


/**
 * Interface that describes MediaPlayerUser methods
 */
public interface MediaPlayerUser {
    /**
     * DOCUMENT ME!
     *
     * @param player DOCUMENT ME!
     */
    public void setPlayer(ElanMediaPlayer player);

    /**
     * DOCUMENT ME!
     */
    public void startPlayer();

    /**
     * DOCUMENT ME!
     */
    public void stopPlayer();

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public boolean playerIsPlaying();

    /**
     * DOCUMENT ME!
     *
     * @param startTime DOCUMENT ME!
     * @param stopTime DOCUMENT ME!
     */
    public void playInterval(long startTime, long stopTime);

    /**
     * DOCUMENT ME!
     *
     * @param milliSeconds DOCUMENT ME!
     */
    public void setMediaTime(long milliSeconds);

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public long getMediaTime();

    /**
     * DOCUMENT ME!
     *
     * @param rate DOCUMENT ME!
     */
    public void setRate(float rate);

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public float getRate();

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public float getVolume();

    /**
     * DOCUMENT ME!
     *
     * @param level DOCUMENT ME!
     */
    public void setVolume(float level);

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public long getMediaDuration();
}
