/*
 * File:     PlayButtonsPanel.java
 * Project:  MPI Linguistic Application
 * Date:     03 April 2006
 *
 * Copyright (C) 2001-2006  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package mpi.eudico.client.annotator;

import mpi.eudico.client.annotator.commands.ELANCommandFactory;

import java.awt.Dimension;
import java.awt.FlowLayout;

import javax.swing.JButton;
import javax.swing.JComponent;


/**
 * DOCUMENT ME!
 * $Id: PlayButtonsPanel.java,v 1.1 2005/08/03 14:59:59 hasloe Exp $
 * @author $Author: hasloe $
 * @version $Revision: 1.1 $
 */
public class PlayButtonsPanel extends JComponent {
    private JButton butPlay;
    private JButton butPrevious;
    private JButton butNext;
    private JButton butGoToBegin;
    private JButton butGoToEnd;
    private JButton but1SecLeft;
    private JButton but1SecRight;
    private JButton but1PixelLeft;
    private JButton but1PixelRight;
    private JButton butGoToPreviousScrollview;
    private JButton butGoToNextScrollview;

    /**
     * Creates a new PlayButtonsPanel instance
     *
     * @param buttonSize DOCUMENT ME!
     * @param theVM DOCUMENT ME!
     */
    public PlayButtonsPanel(Dimension buttonSize, ViewerManager2 theVM) {
        FlowLayout flowLayout = new FlowLayout(FlowLayout.LEFT, 0, 0);
        setLayout(flowLayout);

        butGoToBegin = new JButton(ELANCommandFactory.getCommandAction(
                    theVM.getTranscription(), ELANCommandFactory.GO_TO_BEGIN));
        butGoToBegin.setPreferredSize(buttonSize);
        add(butGoToBegin);

        butGoToPreviousScrollview = new JButton(ELANCommandFactory.getCommandAction(
                    theVM.getTranscription(),
                    ELANCommandFactory.PREVIOUS_SCROLLVIEW));
        butGoToPreviousScrollview.setPreferredSize(buttonSize);
        add(butGoToPreviousScrollview);

        but1SecLeft = new JButton(ELANCommandFactory.getCommandAction(
                    theVM.getTranscription(), ELANCommandFactory.SECOND_LEFT));
        but1SecLeft.setPreferredSize(buttonSize);
        add(but1SecLeft);

        butPrevious = new JButton(ELANCommandFactory.getCommandAction(
                    theVM.getTranscription(), ELANCommandFactory.PREVIOUS_FRAME));
        butPrevious.setPreferredSize(buttonSize);
        add(butPrevious);

        but1PixelLeft = new JButton(ELANCommandFactory.getCommandAction(
                    theVM.getTranscription(), ELANCommandFactory.PIXEL_LEFT));
        but1PixelLeft.setPreferredSize(buttonSize);
        add(but1PixelLeft);

        butPlay = new JButton(ELANCommandFactory.getCommandAction(
                    theVM.getTranscription(), ELANCommandFactory.PLAY_PAUSE));
        butPlay.setPreferredSize(buttonSize);
        add(butPlay);

        but1PixelRight = new JButton(ELANCommandFactory.getCommandAction(
                    theVM.getTranscription(), ELANCommandFactory.PIXEL_RIGHT));
        but1PixelRight.setPreferredSize(buttonSize);
        add(but1PixelRight);

        butNext = new JButton(ELANCommandFactory.getCommandAction(
                    theVM.getTranscription(), ELANCommandFactory.NEXT_FRAME));
        butNext.setPreferredSize(buttonSize);
        add(butNext);

        but1SecRight = new JButton(ELANCommandFactory.getCommandAction(
                    theVM.getTranscription(), ELANCommandFactory.SECOND_RIGHT));
        but1SecRight.setPreferredSize(buttonSize);
        add(but1SecRight);

        butGoToNextScrollview = new JButton(ELANCommandFactory.getCommandAction(
                    theVM.getTranscription(), ELANCommandFactory.NEXT_SCROLLVIEW));
        butGoToNextScrollview.setPreferredSize(buttonSize);
        add(butGoToNextScrollview);

        butGoToEnd = new JButton(ELANCommandFactory.getCommandAction(
                    theVM.getTranscription(), ELANCommandFactory.GO_TO_END));
        butGoToEnd.setPreferredSize(buttonSize);
        add(butGoToEnd);
    }
}
