/*
 * File:     SelectionButtonsPanel.java
 * Project:  MPI Linguistic Application
 * Date:     03 April 2006
 *
 * Copyright (C) 2001-2006  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package mpi.eudico.client.annotator;

import mpi.eudico.client.annotator.commands.ELANCommandFactory;

import java.awt.Dimension;
import java.awt.FlowLayout;

import javax.swing.JButton;
import javax.swing.JComponent;


/**
 * DOCUMENT ME!
 * $Id: SelectionButtonsPanel.java,v 1.1 2005/08/03 15:00:00 hasloe Exp $
 * @author $Author: hasloe $
 * @version $Revision: 1.1 $
 */
public class SelectionButtonsPanel extends JComponent {
    private JButton butPlaySelection;
    private JButton butClearSelection;
    private JButton butToggleCrosshairInSelection;

    /**
     * Creates a new SelectionButtonsPanel instance
     *
     * @param buttonSize DOCUMENT ME!
     * @param theVM DOCUMENT ME!
     */
    public SelectionButtonsPanel(Dimension buttonSize, ViewerManager2 theVM) {
        FlowLayout flowLayout = new FlowLayout(FlowLayout.LEFT, 0, 0);
        setLayout(flowLayout);

        butPlaySelection = new JButton(ELANCommandFactory.getCommandAction(
                    theVM.getTranscription(), ELANCommandFactory.PLAY_SELECTION));
        butPlaySelection.setPreferredSize(buttonSize);
        add(butPlaySelection);

        butClearSelection = new JButton(ELANCommandFactory.getCommandAction(
                    theVM.getTranscription(), ELANCommandFactory.CLEAR_SELECTION));
        butClearSelection.setPreferredSize(buttonSize);
        add(butClearSelection);

        butToggleCrosshairInSelection = new JButton(ELANCommandFactory.getCommandAction(
                    theVM.getTranscription(),
                    ELANCommandFactory.SELECTION_BOUNDARY));
        butToggleCrosshairInSelection.setPreferredSize(buttonSize);
        add(butToggleCrosshairInSelection);
    }
}
