/*
 * File:     AboutDialogCommand.java
 * Project:  MPI Linguistic Application
 * Date:     03 April 2006
 *
 * Copyright (C) 2001-2006  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package mpi.eudico.client.annotator.commands;

import mpi.eudico.client.annotator.ElanLocale;

import mpi.eudico.server.corpora.clom.Transcription;

import java.awt.Font;

import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JOptionPane;


/**
 *
 */
public class AboutDialogCommand implements Command {
    private String commandName;
    private Transcription transcription;

    /**
     * Creates a new AboutDialogCommand instance
     *
     * @param name DOCUMENT ME!
     */
    public AboutDialogCommand(String name) {
        commandName = name;
    }

    /**
     * DOCUMENT ME!
     *
     * @param receiver DOCUMENT ME!
     * @param arguments DOCUMENT ME!
     */
    public void execute(Object receiver, Object[] arguments) {
        transcription = (Transcription) (arguments[0]);

        Icon icon = new ImageIcon(this.getClass().getResource("/mpi/eudico/client/annotator/resources/EUDICO.gif"));

        /*
           String strSelectedMediaFramework = "\n\nMedia played with: " + System.getProperty(DetectMediaFrameworks.FRAMEWORK);
           //String strAboutText = ElanLocale.getString("Menu.Help.AboutText") + strSelectedMediaFramework;
           String strAboutText = ElanLocale.getString("Menu.Help.AboutText");
         */
        /*
           if (System.getProperty("os.name").toLowerCase().startsWith("mac"))
           {
               strMedia = "Quicktime Video and Audio";
           }
           else if (System.getProperty("os.name").toLowerCase().startsWith("win"))
           {
               strMedia = "JMF Video and Audio";
           }
         */
        /*
        String strMedia = ELANCommandFactory.getViewerManager(transcription)
                                            .getMasterMediaPlayer()
                                            .getFrameworkDescription();
        String strSelectedMediaFramework = "\n\n" + ElanLocale.getString("Player.Framework")+ ":\n" +
            strMedia;

        String strAboutText = ElanLocale.getString("Menu.Help.AboutText") +
            strSelectedMediaFramework;
        */
        StringBuffer textBuf = new StringBuffer("<html>");
        textBuf.append("<b>");
        textBuf.append(ElanLocale.getString("Menu.Help.AboutText"));
        textBuf.append("</b><br><br><br>");
        textBuf.append(ElanLocale.getString("Menu.Help.AboutText.GPL"));
        textBuf.append("<br><br>");
        textBuf.append(ElanLocale.getString("Player.Framework") + ":");
        textBuf.append("<br>");
        textBuf.append(ELANCommandFactory.getViewerManager(transcription)
                                         .getMasterMediaPlayer()
                                         .getFrameworkDescription());
        textBuf.append("</html>");

        JLabel label = new JLabel(textBuf.toString().replaceAll("\\u000A",
                    "<br>"));
        label.setFont(label.getFont().deriveFont(Font.PLAIN));

        JOptionPane.showMessageDialog(ELANCommandFactory.getRootFrame(
                transcription), label,
            ElanLocale.getString("Menu.Help.AboutDialog"),
            JOptionPane.PLAIN_MESSAGE, icon);
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public String getName() {
        return commandName;
    }
}
