/*
 * File:     ActiveSelectionBoundaryCA.java
 * Project:  MPI Linguistic Application
 * Date:     03 April 2006
 *
 * Copyright (C) 2001-2006  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package mpi.eudico.client.annotator.commands;

import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.ViewerManager2;

import mpi.eudico.client.mediacontrol.ControllerEvent;
import mpi.eudico.client.mediacontrol.ControllerListener;
import mpi.eudico.client.mediacontrol.TimeEvent;

import java.awt.Toolkit;
import java.awt.event.KeyEvent;

import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.KeyStroke;


/**
 * DOCUMENT ME! $Id: ActiveSelectionBoundaryCA.java,v 1.1.1.1 2004/03/25
 * 16:23:15 wouthuij Exp $
 *
 * @author $Author: klasal $
 * @version $Revision: 1.2 $
 */
public class ActiveSelectionBoundaryCA extends CommandAction
    implements ControllerListener {
    private Icon leftIcon;
    private Icon rightIcon;
    private boolean leftActive = false;

    /**
     * Creates a new ActiveSelectionBoundaryCA instance
     *
     * @param theVM DOCUMENT ME!
     */
    public ActiveSelectionBoundaryCA(ViewerManager2 theVM) {
        //super();
        super(theVM, ELANCommandFactory.SELECTION_BOUNDARY);

        // ask ViewerManager to connect to player
        vm.connectListener(this);

        leftIcon = new ImageIcon(this.getClass().getResource("/mpi/eudico/client/annotator/resources/CrosshairInSelectionLeft.gif"));
        rightIcon = new ImageIcon(this.getClass().getResource("/mpi/eudico/client/annotator/resources/CrosshairInSelectionRight.gif"));
        putValue(SMALL_ICON, leftIcon);

        putValue(Action.ACCELERATOR_KEY,
            KeyStroke.getKeyStroke(KeyEvent.VK_SLASH,
                Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        putValue(SHORT_DESCRIPTION,
            ElanLocale.getString(ELANCommandFactory.SELECTION_BOUNDARY +
                "ToolTip"));
        putValue(DEFAULT, "SELECTION_BOUNDARY");
        putValue(Action.NAME, "");
    }

    /**
     * DOCUMENT ME!
     */
    protected void newCommand() {
        command = ELANCommandFactory.createCommand(vm.getTranscription(),
                ELANCommandFactory.SELECTION_BOUNDARY);
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    protected Object getReceiver() {
        return vm.getMediaPlayerController();
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    protected Object[] getArguments() {
        Object[] args = new Object[3];
        args[0] = vm.getMasterMediaPlayer();
        args[1] = vm.getSelection();
        args[2] = this;

        return args;
    }

    /**
     * DOCUMENT ME!
     *
     * @param event DOCUMENT ME!
     */
    public void controllerUpdate(ControllerEvent event) {
        if (event instanceof TimeEvent) {
            if (vm.getMediaPlayerController().isBeginBoundaryActive() &&
                    !leftActive) {
                setLeftIcon(false);
                leftActive = true;
            }

            if (!vm.getMediaPlayerController().isBeginBoundaryActive() &&
                    leftActive) {
                setLeftIcon(true);
                leftActive = false;
            }
        }
    }

    /**
     * DOCUMENT ME!
     *
     * @param left DOCUMENT ME!
     */
    public void setLeftIcon(boolean left) {
        if (left) {
            putValue(SMALL_ICON, leftIcon);
        } else {
            putValue(SMALL_ICON, rightIcon);
        }
    }
}
