/*
 * File:     ActiveTierCommand.java
 * Project:  MPI Linguistic Application
 * Date:     03 April 2006
 *
 * Copyright (C) 2001-2006  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package mpi.eudico.client.annotator.commands;

import mpi.eudico.client.annotator.viewer.MultiTierControlPanel;


/**
 * Sets the next (down) or previous (up) tier active in the multitier control
 * panel  and thus in the TimeLineViewer.
 *
 * @author Han Sloetjes
 */
public class ActiveTierCommand implements Command {
    private String commandName;

    /**
     * Constructor.
     *
     * @param commandName the name of the command
     */
    public ActiveTierCommand(String commandName) {
        this.commandName = commandName;
    }

    /**
     * <b>Note: </b>it is assumed the types and order of the arguments are
     * correct.
     *
     * @param receiver the MultiTierControlPanel
     * @param arguments the arguments:  <ul><li>arg[0] = the direction of
     *        activation,  next tier (vertically down) or previous tier
     *        (vertically up). True means next (down), false means previous
     *        (down).  (Boolean)</li> </ul>
     */
    public void execute(Object receiver, Object[] arguments) {
        MultiTierControlPanel controlPanel = (MultiTierControlPanel) receiver;
        boolean next = ((Boolean) arguments[0]).booleanValue();
        controlPanel.setNextActiveTier(next);
    }

    /**
     * Returns the name of the command.
     *
     * @return the name of the command
     */
    public String getName() {
        return commandName;
    }
}
