/*
 * File:     AddCVEntryCommand.java
 * Project:  MPI Linguistic Application
 * Date:     03 April 2006
 *
 * Copyright (C) 2001-2006  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package mpi.eudico.client.annotator.commands;

import mpi.eudico.server.corpora.clomimpl.type.CVEntry;
import mpi.eudico.server.corpora.clomimpl.type.ControlledVocabulary;


/**
 * A Command to add an entry to a Controlled Vocabulary.
 *
 * @author Han Sloetjes
 */
public class AddCVEntryCommand implements Command {
    private String commandName;

    /**
     * Creates a new AddCVEntryCommand instance
     *
     * @param name the name of the command
     */
    public AddCVEntryCommand(String name) {
        commandName = name;
    }

    /**
     * <b>Note: </b>it is assumed the types and order of the arguments are
     * correct.<br>
     * When the CV is connected to a Transcription it will handle the notification
     * of the change.
     *
     * @param receiver the Controlled Vocabulary
     * @param arguments the arguments: <ul> <li>arg[0] = the value
     *        of the new entry (String)</li> <li>arg[1] = the description of
     *        the  new entry</li> </ul>
     */
    public void execute(Object receiver, Object[] arguments) {
        ControlledVocabulary conVoc = (ControlledVocabulary) receiver;
        String value = (String) arguments[0];
        String desc = (String) arguments[1];
        CVEntry entry = new CVEntry(value, desc);

        conVoc.addEntry(entry);
    }

    /**
     * Returns the name of the command.
     *
     * @return the name of the command
     */
    public String getName() {
        return commandName;
    }
}
