/*
 * File:     AddTierDlgCommand.java
 * Project:  MPI Linguistic Application
 * Date:     03 April 2006
 *
 * Copyright (C) 2001-2006  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package mpi.eudico.client.annotator.commands;

import mpi.eudico.client.annotator.gui.EditTierDialog;

import mpi.eudico.server.corpora.clom.Transcription;

import java.awt.Dialog;

import javax.swing.JFrame;


/**
 * DOCUMENT ME!
 * $Id: AddTierDlgCommand.java,v 1.2 2005/08/17 13:24:00 hasloe Exp $
 * @author $Author: hasloe $
 * @version $Revision: 1.2 $
 */
public class AddTierDlgCommand implements Command {
    private String commandName;

    /**
     * Creates a new AddTierDlgCommand instance
     *
     * @param theName DOCUMENT ME!
     */
    public AddTierDlgCommand(String theName) {
        commandName = theName;
    }

    /**
     * DOCUMENT ME!
     *
     * @param receiver DOCUMENT ME!
     * @param arguments DOCUMENT ME!
     */
    public void execute(Object receiver, Object[] arguments) {
        // receiver is transcription
        Transcription transcription = (Transcription) receiver;
        JFrame fr = ELANCommandFactory.getRootFrame(transcription);

        Dialog dialog = new EditTierDialog(fr, true, transcription,
                EditTierDialog.ADD, null);
        dialog.setVisible(true);
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public String getName() {
        return commandName;
    }
}
