/*
 * File:     CommandAction.java
 * Project:  MPI Linguistic Application
 * Date:     03 April 2006
 *
 * Copyright (C) 2001-2006  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package mpi.eudico.client.annotator.commands;

import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.ElanLocaleListener;
import mpi.eudico.client.annotator.ViewerManager2;

import java.awt.event.ActionEvent;

import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;


/**
 * DOCUMENT ME! $Id: CommandAction.java,v 1.3 2006/03/30 15:01:31 hasloe Exp $
 *
 * @author $Author: hasloe $
 * @version $Revision: 1.3 $
 */
public abstract class CommandAction extends AbstractAction
    implements ElanLocaleListener {
    /** Holds value of property DOCUMENT ME! */
    protected Command command;
    private String commandId;

    /** Holds value of property DOCUMENT ME! */
    protected ViewerManager2 vm;

    public CommandAction(ViewerManager2 theVM, String name) {
        super(name);

        vm = theVM;
        commandId = name;

        ElanLocale.addElanLocaleListener(vm.getTranscription(), this);
        updateLocale();
    }

    /**
     * Creates a new CommandAction instance
     *
     * @param theVM DOCUMENT ME!
     * @param name DOCUMENT ME!
     * @param icon DOCUMENT ME!
     */
    public CommandAction(ViewerManager2 theVM, String name, Icon icon) {
        super(name, icon);

        vm = theVM;
        commandId = name;

        ElanLocale.addElanLocaleListener(vm.getTranscription(), this);
        updateLocale();
    }

    /**
     * DOCUMENT ME!
     */
    protected abstract void newCommand();

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    protected Object getReceiver() {
        return null;
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    protected Object[] getArguments() {
        return null;
    }

    /**
     * DOCUMENT ME!
     *
     * @param event DOCUMENT ME!
     */
    public void actionPerformed(ActionEvent event) {
        newCommand();

        if (command != null) {
            command.execute(getReceiver(), getArguments());
        }
    }

    // external command sent (e.g. via P2P network)
    public void externalCommand(Object receiver, Object[] args) {
        newCommand();

        if (receiver == null) {
            receiver = getReceiver();
        }

        if (args == null) {
            args = getArguments();
        }

        if (command != null) {
            command.execute(receiver, args);
        }
    }

    /**
     * DOCUMENT ME!
     */
    public void updateLocale() {
        Object newString = null;

        if (commandId != null) {
            newString = "" + ElanLocale.getString(commandId);
        }

        //when there is an icon, set text to empty string (otherwise text appears on a button)
        //also handle the tooltip text
        Object[] obj = getKeys();

        for (int i = 0; i < obj.length; i++) {
            if (obj[i].equals("SmallIcon")) {
                newString = "";
            }
        }

        Object object = getValue(Action.SHORT_DESCRIPTION);

        if ((object != null) && (object.equals("") == false)) {
            putValue(Action.SHORT_DESCRIPTION,
                ElanLocale.getString(commandId + "ToolTip"));
        }

        putValue(Action.NAME, newString);

        //setting mnemonic when needed
        String strDefault = (String) getValue(DEFAULT);

        if (strDefault != null) {
            String strMnemonic = "";

            try {
                strMnemonic = ElanLocale.getString("MNEMONIC." + strDefault);
            } catch (Exception ex) {
            }

            if (strMnemonic.equals("") == false) {
                putValue(MNEMONIC_KEY, new Integer(strMnemonic));
            }
        }
    }
}
