/*
 * File:     EditLingTypeDlgCommand.java
 * Project:  MPI Linguistic Application
 * Date:     03 April 2006
 *
 * Copyright (C) 2001-2006  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package mpi.eudico.client.annotator.commands;

import mpi.eudico.client.annotator.gui.EditTypeDialog;

import mpi.eudico.server.corpora.clom.Transcription;

import javax.swing.JFrame;


/**
 * Creates a JDialog for defining, changing or deleting a Linguistic Type.
 *
 * @author Han Sloetjes
 */
public class EditLingTypeDlgCommand implements Command {
    private String commandName;

    /**
     * Creates a new EditLingTypeDlgCommand instance
     *
     * @param name DOCUMENT ME!
     */
    public EditLingTypeDlgCommand(String name) {
        commandName = name;
    }

    /**
     * <b>Note: </b>it is assumed the types and order of the arguments are
     * correct.
     *
     * @param receiver the transcription
     * @param arguments the arguments:  <ul><li>arg[0] = the dialog mode
     *        (Integer)</li> </ul>
     */
    public void execute(Object receiver, Object[] arguments) {
        // receiver is a transcription
        // arguments[0] is the edit mode, ADD, CHANGE or DELETE
        Transcription transcription = (Transcription) receiver;
        JFrame frame = ELANCommandFactory.getRootFrame(transcription);
        Integer mode = (Integer) arguments[0];
        new EditTypeDialog(frame, true, transcription, mode.intValue()).setVisible(true);
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public String getName() {
        return commandName;
    }
}
