/*
 * File:     ExportCHATCommand.java
 * Project:  MPI Linguistic Application
 * Date:     03 April 2006
 *
 * Copyright (C) 2001-2006  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package mpi.eudico.client.annotator.commands;

import mpi.eudico.client.annotator.export.CHATExportDlg;

import mpi.eudico.server.corpora.clom.Transcription;

import mpi.eudico.server.corpora.clomimpl.dobes.ACM23TranscriptionStore;

import java.util.Vector;

import javax.swing.JDialog;
import javax.swing.JFrame;


/**
 * DOCUMENT ME!
 *
 * @author Hennie Brugman
 */
public class ExportCHATCommand implements Command {
    private String commandName;

    /**
     * Creates a new StoreCommand instance
     *
     * @param name DOCUMENT ME!
     */
    public ExportCHATCommand(String name) {
        commandName = name;
    }

    public void execute(Object receiver, Object[] arguments) {
        //arguments:
        //[0]: ACM23TranscriptionStore eafTranscriptionStore
        //[1]: Vector visibleTiers
        Transcription tr = (Transcription) receiver;
        ACM23TranscriptionStore eafTranscriptionStore = (ACM23TranscriptionStore) arguments[0];

        Vector visibleTiers;

        if (arguments[1] != null) {
            visibleTiers = (Vector) arguments[1];
        } else {
            visibleTiers = ELANCommandFactory.getViewerManager(tr)
                                             .getMultiTierControlPanel()
                                             .getVisibleTiers();
        }

        JFrame fr = ELANCommandFactory.getRootFrame(tr);

        JDialog dlg = new CHATExportDlg(fr, true, tr, eafTranscriptionStore,
                visibleTiers);
        dlg.setVisible(true);
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public String getName() {
        return commandName;
    }
}
