/*
 * File:     ExportImageFromWindowCA.java
 * Project:  MPI Linguistic Application
 * Date:     03 April 2006
 *
 * Copyright (C) 2001-2006  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package mpi.eudico.client.annotator.commands;

import mpi.eudico.client.annotator.ViewerManager2;


/**
 * A CommanAction for the export of an image of the Elan frame.
 *
 * @author Han Sloetjes
 */
public class ExportImageFromWindowCA extends CommandAction {
    /**
     * Creates a Command Action for the export of an image of the Elan Frame.
     *
     * @param theVM the ViewerManager
     */
    public ExportImageFromWindowCA(ViewerManager2 theVM) {
        super(theVM, ELANCommandFactory.EXPORT_IMAGE_FROM_WINDOW);
    }

    /**
     * Creates a new Command.
     */
    protected void newCommand() {
        command = ELANCommandFactory.createCommand(vm.getTranscription(),
                ELANCommandFactory.EXPORT_IMAGE_FROM_WINDOW);
    }

    /**
     * There's no natural receiver for this CommandAction.
     *
     * @return DOCUMENT ME!
     */
    protected Object getReceiver() {
        return null;
    }

    /**
     * Returns the Transcription as the only argument.
     *
     * @return an array containing the Transcription
     */
    protected Object[] getArguments() {
        return new Object[] { vm.getTranscription() };
    }
}
