/*
 * File:     ExportMediaCommand.java
 * Project:  MPI Linguistic Application
 * Date:     03 April 2006
 *
 * Copyright (C) 2001-2006  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package mpi.eudico.client.annotator.commands;

import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.Selection;
import mpi.eudico.client.annotator.ViewerManager2;

import mpi.eudico.client.annotator.export.ExportSmilDialog;

import mpi.eudico.client.annotator.player.ElanMediaPlayer;

import mpi.eudico.server.corpora.clom.Transcription;

import mpi.eudico.server.corpora.clomimpl.dobes.EAF21TranscriptionStore;

import javax.swing.JFileChooser;
import javax.swing.JOptionPane;


/**
 *
 */
public class ExportMediaCommand implements Command {
    private String commandName;

    /**
     * Creates a new ExportSmilCommand instance
     *
     * @param theName DOCUMENT ME!
     */
    public ExportMediaCommand(String theName) {
        commandName = theName;
    }

    /**
     * <b>Note: </b>it is assumed the types and order of the arguments are
     * correct.
     *
     * For the time being only the master media is exported
     * M2-edeit-cl only supports mpeg1 and mpeg2 files,
     * for wav clips use java code based on wav reader code
     *
     * @param receiver null
     * @param arguments the arguments:  <ul><li>arg[0] = the Viewer Manager
     *        (ViewerManager2)</li> </ul>
     */
    public void execute(Object receiver, Object[] arguments) {
        ViewerManager2 viewerManager = (ViewerManager2) arguments[0];

        if (viewerManager != null) {
            Selection selection = viewerManager.getSelection();

            if (selection != null) {
                // do something to point to source media and target media file name
                // and maybe also give the option to define a time interval independent of the current selection
                // for the time being the clip is saved in the fiel pointed to by a file chooser
                String saveDir = (String) Preferences.get("MediaDir", null);
                ElanMediaPlayer player = viewerManager.getMasterMediaPlayer();
                long offset = player.getOffset();

                if (saveDir == null) {
                    saveDir = System.getProperty("user.dir");
                }

                JFileChooser chooser = new JFileChooser(saveDir);
                int option = chooser.showSaveDialog(ELANCommandFactory.getRootFrame(
                            viewerManager.getTranscription()));

                if (option == JFileChooser.APPROVE_OPTION) {
                    try {
                        long frameDuration = player.getMilliSecondsPerSample();
                        long beginFrame = (offset + selection.getBeginTime()) / frameDuration;
                        long endFrame = (long) Math.ceil(((double) offset +
                                selection.getEndTime()) / frameDuration);

                        // M2-edit-class can handle unix type path delimiters
                        String sourceFileName = player.getMediaDescriptor().mediaURL.substring(8);

                        String saveFileName = chooser.getSelectedFile()
                                                     .getAbsolutePath();

                        // check for extension
                        if (!saveFileName.toLowerCase().endsWith(".mpg") &&
                                !saveFileName.toLowerCase().endsWith(".mpeg")) {
                            saveFileName += ".mpg";
                        }

                        String[] command = new String[5];
                        command[0] = "M2-edit-cl";
                        command[1] = "/in:" + beginFrame;
                        command[2] = "/out:" + endFrame;
                        command[3] = sourceFileName;
                        command[4] = saveFileName;
                        System.out.println(command[0] + " " + command[1] + " " +
                            command[2] + " " + command[3] + " " + command[4]);
                        Runtime.getRuntime().exec(command);
                        System.out.println("exported clip");
                    } catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public String getName() {
        return commandName;
    }
}
