/*
 * File:     ExportSmilCommand.java
 * Project:  MPI Linguistic Application
 * Date:     03 April 2006
 *
 * Copyright (C) 2001-2006  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package mpi.eudico.client.annotator.commands;

import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.Selection;

import mpi.eudico.client.annotator.export.ExportSmilDialog;

import mpi.eudico.server.corpora.clom.Transcription;

import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;
import mpi.eudico.server.corpora.clomimpl.dobes.ACM23TranscriptionStore;

import javax.swing.JOptionPane;


/**
 * Created on Apr 15, 2004
 * @author Alexander Klassmann
 * @version Apr 15, 2004
 */
public class ExportSmilCommand implements Command {
    private String commandName;

    /**
     * Creates a new ExportSmilCommand instance
     *
     * @param theName DOCUMENT ME!
     */
    public ExportSmilCommand(String theName) {
        commandName = theName;
    }

    /**
     * <b>Note: </b>it is assumed the types and order of the arguments are
     * correct.
     *
     * @param receiver null
     * @param arguments the arguments:  <ul><li>arg[0] = the Transcription
     *        object(Transcription)</li> <li>arg[1] = the Selection object
     *        (Selection)</li> </ul>
     */
    public void execute(Object receiver, Object[] arguments) {
        Transcription transcription = (Transcription) arguments[0];

        try {
            if ((transcription != null) && transcription.isChanged()) {
                boolean saveNewCopy = false;

                int response = JOptionPane.showConfirmDialog(null,
                        ElanLocale.getString("ExportSmil.Info") + "\n" +
                        ElanLocale.getString("Frame.ElanFrame.UnsavedData"),
                        ElanLocale.getString("Message.Warning"),
                        JOptionPane.YES_NO_CANCEL_OPTION);

                if (response == JOptionPane.YES_OPTION) {
                    if (transcription.getName().equals(TranscriptionImpl.UNDEFINED_FILE_NAME)) {
                        // save as dialog
                        saveNewCopy = true;
                    } else {
                        // do a normal save
                        saveNewCopy = false;
                    }

                    ACM23TranscriptionStore ets = new ACM23TranscriptionStore();
                    StoreCommand storeComm = new StoreCommand(ELANCommandFactory.STORE);
                    storeComm.execute(transcription,
                        new Object[] {
                            ets, new Boolean(false), new Boolean(saveNewCopy),
                            null
                        });
                } else if ((response == JOptionPane.CANCEL_OPTION) ||
                        (response == JOptionPane.CLOSED_OPTION)) {
                    return;
                }
            }

            new ExportSmilDialog(ELANCommandFactory.getRootFrame(
                    (Transcription) arguments[0]), true,
                (Transcription) arguments[0], (Selection) arguments[1]).setVisible(true);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public String getName() {
        return commandName;
    }
}
