/*
 * File:     ModifyAnnotationTimeCA.java
 * Project:  MPI Linguistic Application
 * Date:     03 April 2006
 *
 * Copyright (C) 2001-2006  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package mpi.eudico.client.annotator.commands;

import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.ViewerManager2;

import mpi.eudico.server.corpora.clomimpl.abstr.AlignableAnnotation;

import java.awt.Toolkit;
import java.awt.event.KeyEvent;

import javax.swing.Action;
import javax.swing.KeyStroke;


/**
 * A command action for modifying an annotation's begin and end time.
 *
 * @author Han Sloetjes
 */
public class ModifyAnnotationTimeCA extends CommandAction {
    /**
     * Creates a new ModifyAnnotationTimeCA instance
     *
     * @param viewerManager DOCUMENT ME!
     */
    public ModifyAnnotationTimeCA(ViewerManager2 viewerManager) {
        super(viewerManager, ELANCommandFactory.MODIFY_ANNOTATION_TIME);
        putValue(Action.ACCELERATOR_KEY,
            KeyStroke.getKeyStroke(KeyEvent.VK_ENTER,
                Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        putValue(SHORT_DESCRIPTION,
            ElanLocale.getString(ELANCommandFactory.MODIFY_ANNOTATION_TIME +
                "ToolTip"));
        putValue(DEFAULT, "MODIFY_ANNOTATION_TIME");
    }

    /**
     * Creates a new ModifyAnnotationTimeCommand. Checks the selection's begin-
     * and endtime as well as the current annotation's begin- and endtime to
     * avoid the  creation of meaningless undoable commands.
     */
    protected void newCommand() {
        if (vm.getActiveAnnotation().getAnnotation() instanceof AlignableAnnotation) {
            AlignableAnnotation aa = (AlignableAnnotation) vm.getActiveAnnotation()
                                                             .getAnnotation();

            if ((vm.getSelection().getBeginTime() != vm.getSelection()
                                                           .getEndTime()) &&
                    ((aa.getBeginTimeBoundary() != vm.getSelection()
                                                         .getBeginTime()) ||
                    (aa.getEndTimeBoundary() != vm.getSelection().getEndTime()))) {
                command = ELANCommandFactory.createCommand(vm.getTranscription(),
                        ELANCommandFactory.MODIFY_ANNOTATION_TIME);
            } else {
                command = null;
            }
        } else {
            command = null;
        }
    }

    /**
     * The receiver of this CommandAction is the Annotation that should be
     * modified.
     *
     * @return DOCUMENT ME!
     */
    protected Object getReceiver() {
        return vm.getActiveAnnotation().getAnnotation();
    }

    /**
     * As arguments the new begin and end time are passed.
     *
     * @return DOCUMENT ME!
     */
    protected Object[] getArguments() {
        return new Object[] {
            new Long(vm.getSelection().getBeginTime()),
            new Long(vm.getSelection().getEndTime())
        };
    }
}
