/*
 * File:     PlayAroundSelectionCA.java
 * Project:  MPI Linguistic Application
 * Date:     03 April 2006
 *
 * Copyright (C) 2001-2006  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package mpi.eudico.client.annotator.commands;

import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.ViewerManager2;

import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;

import javax.swing.Action;
import javax.swing.KeyStroke;


/**
 * Plays the selection with a certain offset.
 *
 * @author Han Sloetjes
 */
public class PlayAroundSelectionCA extends CommandAction {
    /**
     * An offset that is used when playing the selection. This amount of
     * milliseconds is prepended and appended to the selection's begin and end
     * time.
     */
    private int playAroundSelectionValue;

    /**
     * Creates a new PlayAroundSelectionCA instance
     *
     * @param theVM DOCUMENT ME!
     */
    public PlayAroundSelectionCA(ViewerManager2 theVM) {
        super(theVM, ELANCommandFactory.PLAY_AROUND_SELECTION);

        // start with a default value of 500 ms
        playAroundSelectionValue = 500;

        //		Command-Space on the Mac is reserved for input method switching
        putValue(Action.ACCELERATOR_KEY,
            KeyStroke.getKeyStroke(KeyEvent.VK_SPACE,
                
        /*Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()*/
        ActionEvent.CTRL_MASK + ActionEvent.SHIFT_MASK));
        putValue(Action.SHORT_DESCRIPTION,
            ElanLocale.getString(ELANCommandFactory.PLAY_AROUND_SELECTION +
                "ToolTip"));
        putValue(DEFAULT, "PLAY_AROUND_SELECTION");
    }

    /**
     * Play around selection and play selection use the same command; play
     * selection passes 0 as offset.
     */
    protected void newCommand() {
        command = ELANCommandFactory.createCommand(vm.getTranscription(),
                ELANCommandFactory.PLAY_SELECTION);
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    protected Object getReceiver() {
        return vm.getMasterMediaPlayer();
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    protected Object[] getArguments() {
        Object[] args = new Object[3];
        args[0] = vm.getSelection();
        args[1] = vm.getMediaPlayerController();
        args[2] = new Integer(playAroundSelectionValue);

        return args;
    }

    /**
     * DOCUMENT ME!
     *
     * @param newValue DOCUMENT ME!
     */
    public void setPlayAroundSelectionValue(int newValue) {
        playAroundSelectionValue = newValue;
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public int getPlayAroundSelectionValue() {
        return playAroundSelectionValue;
    }
}
