/*
 * File:     PlaySelectionCommand.java
 * Project:  MPI Linguistic Application
 * Date:     03 April 2006
 *
 * Copyright (C) 2001-2006  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package mpi.eudico.client.annotator.commands;

import mpi.eudico.client.annotator.ElanMediaPlayerController;
import mpi.eudico.client.annotator.Selection;

import mpi.eudico.client.annotator.player.ElanMediaPlayer;


/**
 * DOCUMENT ME!
 * $Id: PlaySelectionCommand.java,v 1.1 2005/08/03 14:59:37 hasloe Exp $
 * @author $Author: hasloe $
 * @version $Revision: 1.1 $
 */
public class PlaySelectionCommand implements Command {
    private String commandName;
    private ElanMediaPlayer player;
    private Selection s;
    private ElanMediaPlayerController mediaPlayerController;
    private long beginTime;
    private long endTime;

    /**
     * Creates a new PlaySelectionCommand instance
     *
     * @param theName DOCUMENT ME!
     */
    public PlaySelectionCommand(String theName) {
        commandName = theName;
    }

    /**
     * DOCUMENT ME!
     *
     * @param receiver DOCUMENT ME!
     * @param arguments DOCUMENT ME!
     */
    public void execute(Object receiver, Object[] arguments) {
        // receiver is master ElanMediaPlayer
        // arguments[0] is Selection
        // arguments[1] is ElanMediaPlayerController
        // arguments[2] is the play around selection value
        player = (ElanMediaPlayer) receiver;
        s = (Selection) arguments[0];
        mediaPlayerController = (ElanMediaPlayerController) arguments[1];

        int playAroundSelectionValue = ((Integer) arguments[2]).intValue();

        if (player == null) {
            return;
        }

        long mediaTime = player.getMediaTime();

        beginTime = s.getBeginTime();
        endTime = s.getEndTime();

        //if there is no selection
        if (beginTime == endTime) {
            return;
        }

        //apply the play around selection value
        if (playAroundSelectionValue > 0) {
            beginTime -= playAroundSelectionValue;

            if (beginTime < 0) {
                beginTime = 0;
            }

            endTime += playAroundSelectionValue;

            if (endTime > player.getMediaDuration()) {
                endTime = player.getMediaDuration();
            }
        }

        //stop if a selection is being played
        if (player.isPlaying()) {
            player.stop();
            mediaPlayerController.setLoopMode(false);

            return;
        }

        //if not playing, start playing
        if ((player.isPlaying() == false) && (mediaTime >= beginTime) &&
                (mediaTime < endTime)) {
            playInterval(mediaTime, endTime);
            doStartLoop();

            return;
        }

        if (mediaPlayerController.getLoopMode() == true) {
            doStartLoop();
        } else {
            playInterval(beginTime, endTime);
        }
    }

    private void playInterval(long beginTime, long endTime) {
        mediaPlayerController.setPlaySelectionMode(true);
        player.playInterval(beginTime, endTime);
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public String getName() {
        return commandName;
    }

    /**
     * DOCUMENT ME!
     */
    public void doStartLoop() {
        LoopThread loopthread = new LoopThread();
        loopthread.start();
    }

    /**
     * Starts a new playing thread when loopmode is true
     */
    private class LoopThread extends Thread {
        /**
         * DOCUMENT ME!
         */
        public void run() {
            while (mediaPlayerController.getLoopMode() == true) {
                playInterval(beginTime, endTime);

                while (player.isPlaying() == true) {
                    try {
                        Thread.sleep(10);
                    } catch (Exception ex) {
                    }
                }

                try {
                    Thread.sleep(mediaPlayerController.getUserTimeBetweenLoops());
                } catch (Exception ex) {
                }
            }
        }
    }

    //end of LoopThread
}
