/*
 * File:     PlaybackRateToggleCommand.java
 * Project:  MPI Linguistic Application
 * Date:     03 April 2006
 *
 * Copyright (C) 2001-2006  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package mpi.eudico.client.annotator.commands;

import mpi.eudico.client.annotator.ViewerManager2;


/**
 * A Command that actually changes the playback rate of the master media
 * player and that updates the rate slider.
 *
 * @author Han Sloetjes
 */
public class PlaybackRateToggleCommand implements Command {
    private String commandName;

    /**
     * Creates a new SetPlaybackToggleCommand instance
     *
     * @param theName the name of the command
     */
    public PlaybackRateToggleCommand(String theName) {
        commandName = theName;
    }

    /**
     * Changes the rate of the master media player and updates the user
     * interface. <b>Note: </b>it is assumed the types and order of the
     * arguments are correct.
     *
     * @param receiver the viewer manager
     * @param arguments the arguments: <ul><li>arg[0] = the new value for the
     *        playback rate toggle (Float)</li> </ul>
     */
    public void execute(Object receiver, Object[] arguments) {
        ViewerManager2 viewerManager = (ViewerManager2) receiver;
        float rate = ((Float) arguments[0]).floatValue();

        viewerManager.getMediaPlayerController().setRate(rate);
    }

    /**
     * Returns the name of the command
     *
     * @return the name of the command
     */
    public String getName() {
        return commandName;
    }
}
