/*
 * File:     PrintPreviewCommand.java
 * Project:  MPI Linguistic Application
 * Date:     03 April 2006
 *
 * Copyright (C) 2001-2006  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package mpi.eudico.client.annotator.commands;

import mpi.eudico.client.annotator.Selection;

import mpi.eudico.client.annotator.interlinear.Interlinear;
import mpi.eudico.client.annotator.interlinear.InterlinearPreviewDlg;

import mpi.eudico.server.corpora.clom.Transcription;

import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;

import javax.swing.JFrame;


/**
 * Shows a dialog with a print preview and ui elements to change parameters.
 *
 * @author Hennie Brugman
 */
public class PrintPreviewCommand implements Command {
    private String commandName;

    /**
     * Creates a new PrintCommand instance
     *
     * @param name the name of the Command
     */
    public PrintPreviewCommand(String name) {
        commandName = name;
    }

    /**
     * Creates the preview dialog.
     *
     * @param receiver a Transcription
     * @param arguments a Selection object (for printing the selection only
     */
    public void execute(Object receiver, Object[] arguments) {
        Transcription tr = (Transcription) receiver;
        Selection sel = (Selection) arguments[0];

        JFrame fr = ELANCommandFactory.getRootFrame(tr);
        Interlinear interlinear = new Interlinear((TranscriptionImpl) tr);

        if ((sel != null) && (sel.getBeginTime() != sel.getEndTime())) {
            interlinear.setSelection(new long[] {
                    sel.getBeginTime(), sel.getEndTime()
                });
        }

        new InterlinearPreviewDlg(fr, true, interlinear).setVisible(true);
    }

    /**
     * Returns the name of the Command
     *
     * @return the name of the Command
     */
    public String getName() {
        return commandName;
    }
}
