/*
 * File:     SaveCommand.java
 * Project:  MPI Linguistic Application
 * Date:     03 April 2006
 *
 * Copyright (C) 2001-2006  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package mpi.eudico.client.annotator.commands;

import mpi.eudico.server.corpora.clom.Transcription;
import mpi.eudico.server.corpora.clom.TranscriptionStore;

import mpi.eudico.server.corpora.clomimpl.dobes.ACM23TranscriptionStore;

import java.util.Vector;


/**
 * DOCUMENT ME!
 *
 * @author Hennie Brugman
 */
public class SaveCommand implements Command {
    private String commandName;

    /**
     * Creates a new SaveCommand instance
     *
     * @param name DOCUMENT ME!
     */
    public SaveCommand(String name) {
        commandName = name;
    }

    /**
     * DOCUMENT ME!
     *
     * @param receiver DOCUMENT ME!
     * @param arguments DOCUMENT ME!
     */
    public void execute(Object receiver, Object[] arguments) {
        Transcription tr = (Transcription) receiver;

        ACM23TranscriptionStore eafTranscriptionStore = (ACM23TranscriptionStore) arguments[0];

        // for the moment, don't deal with visible tiers
        eafTranscriptionStore.storeTranscription(tr, null, new Vector(), null,
            TranscriptionStore.EAF);
        tr.setUnchanged();
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public String getName() {
        return commandName;
    }
}
