/*
 * File:     SearchMultipleDialogCommand.java
 * Project:  MPI Linguistic Application
 * Date:     03 April 2006
 *
 * Copyright (C) 2001-2006  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package mpi.eudico.client.annotator.commands;

import mpi.eudico.client.annotator.ElanFrame2;
import mpi.eudico.client.annotator.ViewerManager2;

import mpi.eudico.client.annotator.search.viewer.EAFMultipleFileSearchFrame;


/**
 * Created on Sep 8, 2004
 * @author Alexander Klassmann
 * @version Sep 8, 2004
 */
public class SearchMultipleDialogCommand implements Command {
    private String commandName;

    /**
     * Creates a new SearchDialogCommand instance
     *
     * @param name DOCUMENT ME!
     */
    public SearchMultipleDialogCommand(String name) {
        commandName = name;
    }

    /**
     * <b>Note: </b>it is assumed the types and order of the arguments are
     * correct.
     *
     * @param receiver null, ther is no clear receiver object for this command
     * @param arguments the arguments:  <ul><li>arg[0] = the ViewerManager for
     *        this document/frame (ViewerManager)</li></ul>
     */
    public void execute(Object receiver, Object[] arguments) {
        ViewerManager2 vm = (ViewerManager2) arguments[0];
        new EAFMultipleFileSearchFrame((ElanFrame2) ELANCommandFactory.getRootFrame(
                vm.getTranscription()));
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public String getName() {
        return commandName;
    }
}
