/*
 * File:     SetLocaleCommand.java
 * Project:  MPI Linguistic Application
 * Date:     03 April 2006
 *
 * Copyright (C) 2001-2006  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package mpi.eudico.client.annotator.commands;

import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.Preferences;

import java.util.Locale;


/**
 * A Command to set the application's Locale.
 *
 * @author Han Sloetjes
 */
public class SetLocaleCommand implements Command {
    private String commandName;

    /**
     * Creates a new SetLocaleCommand instance
     *
     * @param name DOCUMENT ME!
     */
    public SetLocaleCommand(String name) {
        commandName = name;
    }

    /**
     * <b>Note: </b>it is assumed the types and order of the arguments are
     * correct.
     *
     * @param receiver null, a static method in ElanLocale is called
     * @param arguments the arguments:  <ul><li>arguments[0] = the new Locale
     *        for the application (Locale)</li> </ul>
     */
    public void execute(Object receiver, Object[] arguments) {
        ElanLocale.setLocale((Locale) arguments[0]);
        Preferences.set("Locale", ElanLocale.getLocale(), null);
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public String getName() {
        return commandName;
    }
}
