/*
 * File:     SetPlaybackToggelDlgCA.java
 * Project:  MPI Linguistic Application
 * Date:     03 April 2006
 *
 * Copyright (C) 2001-2006  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package mpi.eudico.client.annotator.commands;

import mpi.eudico.client.annotator.ViewerManager2;


/**
 * Brings up a JDialog for setting the playback rate and volume toggle
 * values.
 *
 * @author Han Sloetjes
 */
public class SetPlaybackToggelDlgCA extends CommandAction {
    /**
     * Creates a new SetPlaybackToggelDlgCA instance the viewer manager
     *
     * @param viewerManager DOCUMENT ME!
     */
    public SetPlaybackToggelDlgCA(ViewerManager2 viewerManager) {
        super(viewerManager, ELANCommandFactory.PLAYBACK_TOGGLE_DLG);
    }

    /**
     * Creates a new command.
     *
     * @see mpi.eudico.client.annotator.commands.CommandAction#newCommand()
     */
    protected void newCommand() {
        command = ELANCommandFactory.createCommand(vm.getTranscription(),
                ELANCommandFactory.PLAYBACK_TOGGLE_DLG);
    }

    /**
     * No receiver.
     *
     * @return null
     */
    protected Object getReceiver() {
        return null;
    }

    /**
     * Returns the arguments.
     *
     * @return the arguments for the command
     */
    protected Object[] getArguments() {
        return new Object[] { vm };
    }
}
