/*
 * File:     SetPlaybackToggleDlgCommand.java
 * Project:  MPI Linguistic Application
 * Date:     03 April 2006
 *
 * Copyright (C) 2001-2006  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package mpi.eudico.client.annotator.commands;

import mpi.eudico.client.annotator.ViewerManager2;

import mpi.eudico.client.annotator.gui.PlaybackToggleDialog;


/**
 * Brings up a JDialog for setting the playback rate and volume toggle values.
 *
 * @author Han Sloetjes
 */
public class SetPlaybackToggleDlgCommand implements Command {
    private String commandName;

    /**
     * Creates a new SetPlaybackToggleDlgCommand instance
     *
     * @param theName the name of the command
     */
    public SetPlaybackToggleDlgCommand(String theName) {
        commandName = theName;
    }

    /**
     * Creates the dialog.
     *
     * @param receiver null
     * @param arguments the arguments (ViewerManager2)
     */
    public void execute(Object receiver, Object[] arguments) {
        ViewerManager2 vm = (ViewerManager2) arguments[0];
        new PlaybackToggleDialog(ELANCommandFactory.getRootFrame(
                vm.getTranscription()), vm).setVisible(true);
    }

    /**
     * Returns the name of the command
     *
     * @return the name of the command
     */
    public String getName() {
        return commandName;
    }
}
