/*
 * File:     ShortcutsCA.java
 * Project:  MPI Linguistic Application
 * Date:     03 April 2006
 *
 * Copyright (C) 2001-2006  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package mpi.eudico.client.annotator.commands;

import mpi.eudico.client.annotator.Constants;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.ViewerManager2;

import java.awt.BorderLayout;
import java.awt.Dimension;

import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTable;


/**
 *
 */
public class ShortcutsCA extends CommandAction {
    private JFrame shortcutsFrame;
    private JTable tableShortcuts;

    /**
     * Creates a new ShortcutsCA instance
     *
     * @param theVM DOCUMENT ME!
     */
    public ShortcutsCA(ViewerManager2 theVM) {
        super(theVM, ELANCommandFactory.SHORTCUTS);
        putValue(DEFAULT, "SHORTCUTS");
        updateLocale(); //because of mnemonic
    }

    /**
     * DOCUMENT ME!
     */
    protected void newCommand() {
        command = ELANCommandFactory.createCommand(vm.getTranscription(),
                ELANCommandFactory.SHORTCUTS);
    }

    /**
     *
     */
    protected Object getReceiver() {
        return null;
    }

    /**
     *
     */
    protected Object[] getArguments() {
        Object[] args = new Object[1];
        args[0] = getShortcutsFrame();

        return args;
    }

    private JFrame getShortcutsFrame() {
        if (shortcutsFrame == null) {
            createShortcutsFrame();
        }

        return shortcutsFrame;
    }

    private void createShortcutsFrame() {
        shortcutsFrame = new JFrame("Shortcuts");

        String[][] objRowData = ELANCommandFactory.getShortCutText(vm.getTranscription());
        String[] objColumnNames = { "", "" };

        tableShortcuts = new JTable(objRowData, objColumnNames);
        tableShortcuts.setBackground(Constants.DEFAULTBACKGROUNDCOLOR);
        tableShortcuts.setPreferredScrollableViewportSize(new Dimension(400, 580));
        tableShortcuts.setEnabled(false);

        tableShortcuts.getColumnModel().getColumn(0).setPreferredWidth(150);
        tableShortcuts.getColumnModel().getColumn(1).setPreferredWidth(250);

        JScrollPane listScrollPane = new JScrollPane(tableShortcuts);

        shortcutsFrame.getContentPane().setLayout(new BorderLayout());
        shortcutsFrame.getContentPane().add(listScrollPane, BorderLayout.CENTER);

        updateLocale();

        shortcutsFrame.pack();
    }

    /**
     * DOCUMENT ME!
     */
    public void updateLocale() {
        super.updateLocale();

        if (tableShortcuts != null) {
            tableShortcuts.getColumnModel().getColumn(0).setHeaderValue(ElanLocale.getString(
                    "Frame.ShortcutFrame.ColumnShortcut"));
            tableShortcuts.getColumnModel().getColumn(1).setHeaderValue(ElanLocale.getString(
                    "Frame.ShortcutFrame.ColumnDescription"));

            String[][] objRowData = ELANCommandFactory.getShortCutText(vm.getTranscription());

            for (int i = 0; i < objRowData.length; i++) {
                tableShortcuts.setValueAt(objRowData[i][1], i, 1);
            }

            shortcutsFrame.setTitle(ElanLocale.getString(
                    "Menu.View.ShortcutsDialog"));
            shortcutsFrame.repaint(); //if tableShortcuts != null, then shortcutsFrame != null too
        }
    }
}
