/*
 * File:     ShowTimelineCA.java
 * Project:  MPI Linguistic Application
 * Date:     03 April 2006
 *
 * Copyright (C) 2001-2006  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package mpi.eudico.client.annotator.commands;

import mpi.eudico.client.annotator.ElanLayoutManager;
import mpi.eudico.client.annotator.ViewerManager2;


/**
 * A command action for making the Timeline viewer visible in the Elan Frame.
 *
 * @author Han Sloetjes
 */
public class ShowTimelineCA extends CommandAction {
    private ElanLayoutManager layoutManager;
    private Object[] args;

    /**
     * Creates a new ShowTimelineCA instance
     *
     * @param theVM DOCUMENT ME!
     * @param layoutManager DOCUMENT ME!
     */
    public ShowTimelineCA(ViewerManager2 theVM, ElanLayoutManager layoutManager) {
        super(theVM, ELANCommandFactory.SHOW_TIMELINE);
        this.layoutManager = layoutManager;
        args = new Object[] { ELANCommandFactory.SHOW_TIMELINE };
    }

    /**
     * DOCUMENT ME!
     */
    protected void newCommand() {
        command = ELANCommandFactory.createCommand(vm.getTranscription(),
                ELANCommandFactory.SHOW_MULTITIER_VIEWER);
    }

    /**
     * The receiver of this CommandAction is the ViewerManager.
     *
     * @return DOCUMENT ME!
     */
    protected Object getReceiver() {
        return layoutManager;
    }

    /**
     * Argument[0] is ELANCommandFactory.SHOW_TIMELINE.
     *
     * @return DOCUMENT ME!
     */
    protected Object[] getArguments() {
        return args;
    }
}
