/*
 * File:     StructuredSearchMultipleDlgCA.java
 * Project:  MPI Linguistic Application
 * Date:     03 April 2006
 *
 * Copyright (C) 2001-2006  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package mpi.eudico.client.annotator.commands;

import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.ViewerManager2;

import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;

import javax.swing.Action;
import javax.swing.KeyStroke;


/**
 * Creates a new structured search in multiple files dialog.
 *
 * @author Han Sloetjes
 */
public class StructuredSearchMultipleDlgCA extends CommandAction {
    /**
     * Creates a new structured search in multiple files action instance.
     *
     * @param theVM the viewermanager
     */
    public StructuredSearchMultipleDlgCA(ViewerManager2 viewerManager) {
        super(viewerManager, ELANCommandFactory.STRUCTURED_SEARCH_MULTIPLE_DLG);
        putValue(Action.ACCELERATOR_KEY,
            KeyStroke.getKeyStroke(KeyEvent.VK_F,
                Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() +
                ActionEvent.SHIFT_MASK + ActionEvent.ALT_MASK));
        putValue(SHORT_DESCRIPTION,
            ElanLocale.getString(ELANCommandFactory.STRUCTURED_SEARCH_MULTIPLE_DLG +
                "ToolTip"));
        putValue(DEFAULT, "STRUCTURED_SEARCH_MULTIPLE_DLG");
    }

    /**
     * Creates a new structured search command.
     *
     * @see mpi.eudico.client.annotator.commands.CommandAction#newCommand()
     */
    protected void newCommand() {
        command = ELANCommandFactory.createCommand(vm.getTranscription(),
                ELANCommandFactory.STRUCTURED_SEARCH_MULTIPLE_DLG);
    }

    /**
     * There is no clear receiver for a search in multiple files action.
     * All necessary objects are passed as arguments to the Search Dialog.
     *
     * @return returns null
     */
    protected Object getReceiver() {
        return null;
    }

    /**
     * Returns an array with the ViewerManager
     *
     * @return an array with the ViewerManager
     */
    protected Object[] getArguments() {
        Object[] args = new Object[] { vm };

        return args;
    }
}
