/*
 * File:     SyncModeCommand.java
 * Project:  MPI Linguistic Application
 * Date:     03 April 2006
 *
 * Copyright (C) 2001-2006  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package mpi.eudico.client.annotator.commands;

import mpi.eudico.client.annotator.ElanLayoutManager;


/**
 * Switches to media synchronization mode.
 *
 * @version 2 a switch to synchronisation mode is now allowed
 * even if there already are annotations.
 *
 * @author Han Sloetjes
 */
public class SyncModeCommand implements Command {
    private String commandName;

    /**
     * Creates a new SyncModeCommand instance
     *
     * @param name DOCUMENT ME!
     */
    public SyncModeCommand(String name) {
        commandName = name;
    }

    /**
     *
     *
     * @param receiver the ElanLayoutManager
     * @param arguments the arguments:  <ul><li>arguments[0] = the
     *        Transcription (Transcription)</li> </ul>
     */
    public void execute(Object receiver, Object[] arguments) {
        ((ElanLayoutManager) receiver).showSyncMode();
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public String getName() {
        return commandName;
    }
}
