/*
 * File:     TierDependenciesCommand.java
 * Project:  MPI Linguistic Application
 * Date:     03 April 2006
 *
 * Copyright (C) 2001-2006  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package mpi.eudico.client.annotator.commands;

import javax.swing.JFrame;


/**
 *
 */
public class TierDependenciesCommand implements Command {
    private String commandName;
    private JFrame dependencyFrame;

    /**
     * Creates a new TierDependenciesCommand instance
     *
     * @param name DOCUMENT ME!
     */
    public TierDependenciesCommand(String name) {
        commandName = name;
    }

    /**
     *
     */
    public void execute(Object receiver, Object[] arguments) {
        dependencyFrame = (JFrame) (arguments[0]);

        showTierDependencies();
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public String getName() {
        return commandName;
    }

    private void showTierDependencies() {
        if (dependencyFrame != null) {
            //Next line useable as of JDK 1.4
            //dependencyFrame.setExtendedState(Frame.NORMAL);
            dependencyFrame.setVisible(true);
            dependencyFrame.toFront();
        }
    }
}
