/*
 * File:     UndoCA.java
 * Project:  MPI Linguistic Application
 * Date:     03 April 2006
 *
 * Copyright (C) 2001-2006  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package mpi.eudico.client.annotator.commands;

import mpi.eudico.client.annotator.ViewerManager2;

import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;

import javax.swing.Action;
import javax.swing.KeyStroke;


/**
 * DOCUMENT ME! $Id: UndoCA.java,v 1.1 2005/08/03 14:59:27 hasloe Exp $
 *
 * @author $Author: hasloe $
 * @version $Revision: 1.1 $
 */
public class UndoCA extends CommandAction {
    private CommandHistory commandHistory;

    /**
     * Creates a new UndoCA instance
     *
     * @param theVM DOCUMENT ME!
     * @param theHistory DOCUMENT ME!
     */
    public UndoCA(ViewerManager2 theVM, CommandHistory theHistory) {
        super(theVM, ELANCommandFactory.UNDO);
        putValue(Action.ACCELERATOR_KEY,
            KeyStroke.getKeyStroke(KeyEvent.VK_Z,
                Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        putValue(DEFAULT, "UNDO");
        commandHistory = theHistory;

        setEnabled(false); // initially disable
        updateLocale(); //because of mnemonic
    }

    /**
     * DOCUMENT ME!
     */
    protected void newCommand() {
    }

    /**
     * DOCUMENT ME!
     *
     * @param event DOCUMENT ME!
     */
    public void actionPerformed(ActionEvent event) {
        commandHistory.undo();
    }
}
