/*
 * File:     ExportTeXDialog.java
 * Project:  MPI Linguistic Application
 * Date:     03 April 2006
 *
 * Copyright (C) 2001-2006  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/* This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
package mpi.eudico.client.annotator.export;

import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.Selection;

import mpi.eudico.client.util.ExportException;
import mpi.eudico.client.util.Transcription2TeX;

import mpi.eudico.server.corpora.clom.Tier;
import mpi.eudico.server.corpora.clom.Transcription;

import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;

import java.awt.Frame;

import java.io.File;
import java.io.IOException;

import java.util.List;

import javax.swing.ListSelectionModel;


/**
 * $Id: ExportTeXDialog.java,v 1.2 2005/08/17 13:24:17 hasloe Exp $
 *
 * @author $Author: hasloe $
 * @version $Revision: 1.2 $
 * @version Aug 2005 Identity removed
 */
public class ExportTeXDialog extends AbstractExportDialog {
    /* (non-Javadoc)
     * @see mpi.eudico.client.annotator.export.AbstractExportDialog#export(java.io.File)
     */

    /** Holds value of property DOCUMENT ME! */
    private Transcription transcription;

    /** Holds value of property DOCUMENT ME! */
    private Selection selection;

    /**
     * Creates a new ExportTabDialog instance
     *
     * @param parent DOCUMENT ME!
     * @param modal DOCUMENT ME!
     * @param transcription DOCUMENT ME!
     * @param selection DOCUMENT ME!
     */
    public ExportTeXDialog(Frame parent, boolean modal,
        Transcription transcription, Selection selection) {
        super(parent, modal);

        this.transcription = transcription;
        this.selection = selection;

        fileExtension = "tex";
        fileDescription = "*.tex";

        setTitle(ElanLocale.getString("ExportTeXDialog.Title"));

        titleLabel.setText(ElanLocale.getString("ExportTeXDialog.TitleLabel"));

        try {
            List tiers = transcription.getTiers();
            String[] tierNames = new String[tiers.size()];

            for (int i = 0; i < tiers.size(); i++) {
                tierNames[i] = ((Tier) tiers.get(i)).getName();
            }

            tierList.setListData(tierNames);
            tierList.setSelectionMode(ListSelectionModel.MULTIPLE_INTERVAL_SELECTION);
            tierList.setSelectedIndex(0);
        } catch (Exception e) {
        }

        setExportFile(ExportUtility.getDefaultExportFile(
                new File(((TranscriptionImpl) transcription).getPathName()),
                fileExtension));

        pack();
    }

    /**
     *
     * @see mpi.eudico.client.annotator.AbstractExportDialog#export(File)
     */
    protected void export(File exportFile) throws IOException, ExportException {
        String[] tierNames = new String[tierList.getSelectedValues().length];

        for (int i = 0; i < tierNames.length; i++) {
            tierNames[i] = (String) tierList.getSelectedValues()[i];
        }

        if (restrictCheckBox.isSelected()) {
            Transcription2TeX.exportTiers(transcription, tierNames, exportFile,
                selection.getBeginTime(), selection.getEndTime());
        } else {
            Transcription2TeX.exportTiers(transcription, tierNames, exportFile);
        }
    }
}
