/*
 * File:     ExportUtility.java
 * Project:  MPI Linguistic Application
 * Date:     03 April 2006
 *
 * Copyright (C) 2001-2006  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package mpi.eudico.client.annotator.export;

import mpi.eudico.client.annotator.Preferences;

import java.io.File;


/**
 * Created on Nov 12, 2004
 * @author Alexander Klassmann
 * @version Nov 12, 2004
 */
public class ExportUtility {
    /**
     *
     * @param eafFile
     * @param extension
     */
    static public File getDefaultExportFile(File eafFile, String extension) {
        String exportDir = (String) Preferences.get("LastUsedExportDir", null);

        if ((exportDir == null) && (eafFile != null)) {
            exportDir = eafFile.getParent();
        }

        if (exportDir == null) {
            exportDir = System.getProperty("user.dir");
        }

        int index = -1;

        if (eafFile != null) {
            index = eafFile.getName().lastIndexOf('.');
        }

        String exportFileName = (index > -1)
            ? eafFile.getName().substring(0, index) : "noname";

        return new File(exportDir, exportFileName + "." + extension);
    }
}
