/*
 * File:     AnnotationTableCellRenderer.java
 * Project:  MPI Linguistic Application
 * Date:     03 April 2006
 *
 * Copyright (C) 2001-2006  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package mpi.eudico.client.annotator.grid;

import mpi.eudico.client.annotator.Constants;

import mpi.eudico.server.corpora.clom.AnnotationCore;

import java.awt.Component;

import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.SwingConstants;
import javax.swing.border.Border;
import javax.swing.table.TableCellRenderer;


/**
 * Renders annotations in a Table (number, value, times, etc)
 *
 * Created on Oct 5, 2004
 * @author Alexander Klassmann
 * @version Oct 5, 2004
 */
public class AnnotationTableCellRenderer implements TableCellRenderer {
    final static protected Border marginBorder = BorderFactory.createEmptyBorder(0,
            1, 0, 3);
    final protected JLabel label;

    public AnnotationTableCellRenderer() {
        // override the defaults for performance reasons
        label = new JLabel() {
                    public void validate() {
                    }

                    public void revalidate() {
                    }

                    protected void firePropertyChange(String propertyName,
                        Object oldValue, Object newValue) {
                    }

                    public void firePropertyChange(String propertyName,
                        boolean oldValue, boolean newValue) {
                    }
                };
        label.setOpaque(true);
    }

    /* (non-Javadoc)
     * @see javax.swing.table.TableCellRenderer#getTableCellRendererComponent(javax.swing.JTable, java.lang.Object, boolean, boolean, int, int)
     */
    public Component getTableCellRendererComponent(JTable table, Object value,
        boolean isSelected, boolean hasFocus, int row, int column) {
        setComponentLayout(label, table, isSelected);
        setAlignment(label, table.getColumnName(column));

        String renderedText = getRenderedText(value);
        label.setText(renderedText);

        if (!"".equals(renderedText)) {
            label.setToolTipText(renderedText);
        }

        return label;
    }

    static protected void setComponentLayout(JComponent component,
        JTable table, boolean isSelected) {
        component.setFont(table.getFont());
        component.setBorder(marginBorder);
        component.setBackground(isSelected ? Constants.SELECTIONCOLOR
                                           : table.getBackground());
    }

    protected void setAlignment(JLabel label, String columnName) {
        if (GridViewerTableModel.COUNT.equals(columnName) ||
                GridViewerTableModel.LEFTCONTEXT.equals(columnName) ||
                GridViewerTableModel.BEGINTIME.equals(columnName) ||
                GridViewerTableModel.ENDTIME.equals(columnName) ||
                GridViewerTableModel.DURATION.equals(columnName)) {
            label.setHorizontalAlignment(SwingConstants.RIGHT);
        } else {
            label.setHorizontalAlignment(SwingConstants.LEFT);
        }
    }

    /**
     * Handles the drawing of the cells with text values.
     *
     * @param isSelected the selected state of the cell
     * @param row the row index
     * @param column the column index
     * @param value the value of the table cell
     */
    static protected String getRenderedText(Object value) {
        if (value instanceof AnnotationCore) {
            return (((AnnotationCore) value).getValue().replace('\n', ' '));
        } else if (value instanceof String) {
            return (String) value;
        } else {
            return "";
        }
    }
}
