/*
 * File:     ElanMenuItem.java
 * Project:  MPI Linguistic Application
 * Date:     03 April 2006
 *
 * Copyright (C) 2001-2006  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package mpi.eudico.client.annotator.gui;

import javax.swing.Action;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;


/**
 * This class extends <code>JMenuItem</code> by getting the  accelerator key
 * from the key-value list and applying this to the menu item.
 *
 * @author Han Sloetjes
 */
public class ElanMenuItem extends JMenuItem {
    /**
     * Constructor for ElanMenuItem. When there is an accelerator key defined
     * it is applied to the menu item.
     *
     * @param a the Action for this menu item
     */
    public ElanMenuItem(Action a) {
        super(a);

        if (a != null) {
            KeyStroke ks = (KeyStroke) a.getValue(Action.ACCELERATOR_KEY);

            if (ks != null) {
                setAccelerator(ks);
            }
        }
    }
}
