/*
 * File:     PrintTester.java
 * Project:  MPI Linguistic Application
 * Date:     03 April 2006
 *
 * Copyright (C) 2001-2006  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package mpi.eudico.client.annotator.interlinear;

import mpi.eudico.server.corpora.clom.Transcription;

import mpi.eudico.server.corpora.clomimpl.abstr.AbstractAnnotation;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;

import java.awt.image.BufferedImage;

import java.util.ArrayList;
import java.util.Vector;


/**
 * @author Han Sloetjes
 */
public class PrintTester {
    TranscriptionImpl transcription;

    public PrintTester(Transcription transcription) {
        this.transcription = (TranscriptionImpl) transcription;
    }

    public void test() {
        /*
            Vector tiers = transcription.getTiers(null);
            ArrayList visTiers = new ArrayList(tiers.size());
            AbstractAnnotation aa = null;
            for (int i = 0; i < tiers.size(); i++) {
                TierImpl t = (TierImpl) tiers.get(i);
                if (!t.getName().equals("W-Words") && !t.getName().equals("W-POS")) {
                    visTiers.add(t);
                }
                if (t.getName().equals("W-Spch")) {
                    Vector ann = t.getAnnotations(null);
                    if (ann.size() > 0) {
                        aa = (AbstractAnnotation) ann.get(0);
                    }
                }
            }
            if (aa != null) {
                AnnotationBlockCreator cr = new AnnotationBlockCreator();
                cr.createBlockForAnnotation(aa, visTiers);
            } else {
                System.out.println("Annotation null");
            }

        */
        Interlinear inter = new Interlinear(transcription,
                Interlinear.INTERLINEAR_TEXT);
        inter.setTimeCodeShown(true);
        inter.setBlockWrapStyle(Interlinear.WITHIN_BLOCKS);
        inter.setLineWrapStyle(Interlinear.NEXT_LINE);

        //inter.setWidth(550);
        //inter.setHeight(600);
        //BufferedImage buf = new BufferedImage(200, 200, BufferedImage.TYPE_INT_RGB);
        //inter.renderView(buf);
        new InterlinearPreviewDlg(null, false, inter).setVisible(true);
    }
}
