/*
 * File:     IAMStats.java
 * Project:  MPI Linguistic Application
 * Date:     03 April 2006
 *
 * Copyright (C) 2001-2006  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package mpi.eudico.client.annotator.nativemedia.quartztypelib;

import com.jniwrapper.*;

import com.jniwrapper.win32.*;

import com.jniwrapper.win32.automation.*;

import com.jniwrapper.win32.automation.impl.*;

import com.jniwrapper.win32.automation.types.*;

import com.jniwrapper.win32.com.*;

import com.jniwrapper.win32.com.impl.*;

import com.jniwrapper.win32.com.types.*;

import mpi.eudico.client.annotator.nativemedia.quartztypelib.impl.*;


/**
 * Represents Java interface for COM interface IAMStats
 */
public interface IAMStats extends IDispatch {
    public static final String INTERFACE_IDENTIFIER = "{BC9BCF80-DCD2-11D2-ABF6-00A0C905F375}";

    void reset() throws ComException;

    Int32 getCount() throws ComException;

    void getValueByIndex(Int32 /*[in]*/ lIndex, BStr /*[out]*/ szName,
        Int32 /*[out]*/ lCount, DoubleFloat /*[out]*/ dLast,
        DoubleFloat /*[out]*/ dAverage, DoubleFloat /*[out]*/ dStdDev,
        DoubleFloat /*[out]*/ dMin, DoubleFloat /*[out]*/ dMax)
        throws ComException;

    void getValueByName(BStr /*[in]*/ szName, Int32 /*[out]*/ lIndex,
        Int32 /*[out]*/ lCount, DoubleFloat /*[out]*/ dLast,
        DoubleFloat /*[out]*/ dAverage, DoubleFloat /*[out]*/ dStdDev,
        DoubleFloat /*[out]*/ dMin, DoubleFloat /*[out]*/ dMax)
        throws ComException;

    Int32 getIndex(BStr /*[in]*/ szName, Int32 /*[in]*/ lCreate)
        throws ComException;

    void addValue(Int32 /*[in]*/ lIndex, DoubleFloat /*[in]*/ dValue)
        throws ComException;
}
