/*
 * File:     IBasicVideo.java
 * Project:  MPI Linguistic Application
 * Date:     03 April 2006
 *
 * Copyright (C) 2001-2006  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package mpi.eudico.client.annotator.nativemedia.quartztypelib;

import com.jniwrapper.*;

import com.jniwrapper.win32.*;

import com.jniwrapper.win32.automation.*;

import com.jniwrapper.win32.automation.impl.*;

import com.jniwrapper.win32.automation.types.*;

import com.jniwrapper.win32.com.*;

import com.jniwrapper.win32.com.impl.*;

import com.jniwrapper.win32.com.types.*;

import mpi.eudico.client.annotator.nativemedia.quartztypelib.impl.*;


/**
 * Represents Java interface for COM interface IBasicVideo
 */
public interface IBasicVideo extends IDispatch {
    public static final String INTERFACE_IDENTIFIER = "{56A868B5-0AD4-11CE-B03A-0020AF0BA770}";

    DoubleFloat getAvgTimePerFrame() throws ComException;

    Int32 getBitRate() throws ComException;

    Int32 getBitErrorRate() throws ComException;

    Int32 getVideoWidth() throws ComException;

    Int32 getVideoHeight() throws ComException;

    void setSourceLeft(Int32 /*[in]*/ pSourceLeft) throws ComException;

    Int32 getSourceLeft() throws ComException;

    void setSourceWidth(Int32 /*[in]*/ pSourceWidth) throws ComException;

    Int32 getSourceWidth() throws ComException;

    void setSourceTop(Int32 /*[in]*/ pSourceTop) throws ComException;

    Int32 getSourceTop() throws ComException;

    void setSourceHeight(Int32 /*[in]*/ pSourceHeight)
        throws ComException;

    Int32 getSourceHeight() throws ComException;

    void setDestinationLeft(Int32 /*[in]*/ pDestinationLeft)
        throws ComException;

    Int32 getDestinationLeft() throws ComException;

    void setDestinationWidth(Int32 /*[in]*/ pDestinationWidth)
        throws ComException;

    Int32 getDestinationWidth() throws ComException;

    void setDestinationTop(Int32 /*[in]*/ pDestinationTop)
        throws ComException;

    Int32 getDestinationTop() throws ComException;

    void setDestinationHeight(Int32 /*[in]*/ pDestinationHeight)
        throws ComException;

    Int32 getDestinationHeight() throws ComException;

    void setSourcePosition(Int32 /*[in]*/ Left, Int32 /*[in]*/ Top,
        Int32 /*[in]*/ Width, Int32 /*[in]*/ Height) throws ComException;

    void getSourcePosition(Int32 /*[out]*/ pLeft, Int32 /*[out]*/ pTop,
        Int32 /*[out]*/ pWidth, Int32 /*[out]*/ pHeight)
        throws ComException;

    void setDefaultSourcePosition() throws ComException;

    void setDestinationPosition(Int32 /*[in]*/ Left, Int32 /*[in]*/ Top,
        Int32 /*[in]*/ Width, Int32 /*[in]*/ Height) throws ComException;

    void getDestinationPosition(Int32 /*[out]*/ pLeft, Int32 /*[out]*/ pTop,
        Int32 /*[out]*/ pWidth, Int32 /*[out]*/ pHeight)
        throws ComException;

    void setDefaultDestinationPosition() throws ComException;

    void getVideoSize(Int32 /*[out]*/ pWidth, Int32 /*[out]*/ pHeight)
        throws ComException;

    void getVideoPaletteEntries(Int32 /*[in]*/ StartIndex,
        Int32 /*[in]*/ Entries, Int32 /*[out]*/ pRetrieved,
        Int32 /*[out]*/ pPalette) throws ComException;

    void getCurrentImage(Int32 /*[in,out]*/ pBufferSize,
        Int32 /*[out]*/ pDIBImage) throws ComException;

    void isUsingDefaultSource() throws ComException;

    void isUsingDefaultDestination() throws ComException;
}
