/*
 * File:     IMediaEvent.java
 * Project:  MPI Linguistic Application
 * Date:     03 April 2006
 *
 * Copyright (C) 2001-2006  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package mpi.eudico.client.annotator.nativemedia.quartztypelib;

import com.jniwrapper.*;

import com.jniwrapper.win32.*;

import com.jniwrapper.win32.automation.*;

import com.jniwrapper.win32.automation.impl.*;

import com.jniwrapper.win32.automation.types.*;

import com.jniwrapper.win32.com.*;

import com.jniwrapper.win32.com.impl.*;

import com.jniwrapper.win32.com.types.*;

import mpi.eudico.client.annotator.nativemedia.quartztypelib.impl.*;


/**
 * Represents Java interface for COM interface IMediaEvent
 */
public interface IMediaEvent extends IDispatch {
    public static final String INTERFACE_IDENTIFIER = "{56A868B6-0AD4-11CE-B03A-0020AF0BA770}";

    LongPtr getEventHandle() throws ComException;

    void getEvent(Int32 /*[out]*/ lEventCode, LongPtr /*[out]*/ lParam1,
        LongPtr /*[out]*/ lParam2, Int32 /*[in]*/ msTimeout)
        throws ComException;

    Int32 waitForCompletion(Int32 /*[in]*/ msTimeout) throws ComException;

    void cancelDefaultHandling(Int32 /*[in]*/ lEvCode)
        throws ComException;

    void restoreDefaultHandling(Int32 /*[in]*/ lEvCode)
        throws ComException;

    void freeEventParams(Int32 /*[in]*/ lEvCode, LongPtr /*[in]*/ lParam1,
        LongPtr /*[in]*/ lParam2) throws ComException;
}
