/*
 * File:     IVideoWindow.java
 * Project:  MPI Linguistic Application
 * Date:     03 April 2006
 *
 * Copyright (C) 2001-2006  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package mpi.eudico.client.annotator.nativemedia.quartztypelib;

import com.jniwrapper.*;

import com.jniwrapper.win32.*;

import com.jniwrapper.win32.automation.*;

import com.jniwrapper.win32.automation.impl.*;

import com.jniwrapper.win32.automation.types.*;

import com.jniwrapper.win32.com.*;

import com.jniwrapper.win32.com.impl.*;

import com.jniwrapper.win32.com.types.*;

import mpi.eudico.client.annotator.nativemedia.quartztypelib.impl.*;


/**
 * Represents Java interface for COM interface IVideoWindow
 */
public interface IVideoWindow extends IDispatch {
    public static final String INTERFACE_IDENTIFIER = "{56A868B4-0AD4-11CE-B03A-0020AF0BA770}";

    void setCaption(BStr /*[in]*/ strCaption) throws ComException;

    BStr getCaption() throws ComException;

    void setWindowStyle(Int32 /*[in]*/ WindowStyle) throws ComException;

    Int32 getWindowStyle() throws ComException;

    void setWindowStyleEx(Int32 /*[in]*/ WindowStyleEx)
        throws ComException;

    Int32 getWindowStyleEx() throws ComException;

    void setAutoShow(Int32 /*[in]*/ AutoShow) throws ComException;

    Int32 getAutoShow() throws ComException;

    void setWindowState(Int32 /*[in]*/ WindowState) throws ComException;

    Int32 getWindowState() throws ComException;

    void setBackgroundPalette(Int32 /*[in]*/ pBackgroundPalette)
        throws ComException;

    Int32 getBackgroundPalette() throws ComException;

    void setVisible(Int32 /*[in]*/ pVisible) throws ComException;

    Int32 getVisible() throws ComException;

    void setLeft(Int32 /*[in]*/ pLeft) throws ComException;

    Int32 getLeft() throws ComException;

    void setWidth(Int32 /*[in]*/ pWidth) throws ComException;

    Int32 getWidth() throws ComException;

    void setTop(Int32 /*[in]*/ pTop) throws ComException;

    Int32 getTop() throws ComException;

    void setHeight(Int32 /*[in]*/ pHeight) throws ComException;

    Int32 getHeight() throws ComException;

    void setOwner(LongPtr /*[in]*/ Owner) throws ComException;

    LongPtr getOwner() throws ComException;

    void setMessageDrain(LongPtr /*[in]*/ Drain) throws ComException;

    LongPtr getMessageDrain() throws ComException;

    Int32 getBorderColor() throws ComException;

    void setBorderColor(Int32 /*[in]*/ Color) throws ComException;

    Int32 getFullScreenMode() throws ComException;

    void setFullScreenMode(Int32 /*[in]*/ FullScreenMode)
        throws ComException;

    void setWindowForeground(Int32 /*[in]*/ Focus) throws ComException;

    void notifyOwnerMessage(LongPtr /*[in]*/ hwnd, Int32 /*[in]*/ uMsg,
        LongPtr /*[in]*/ wParam, LongPtr /*[in]*/ lParam)
        throws ComException;

    void setWindowPosition(Int32 /*[in]*/ Left, Int32 /*[in]*/ Top,
        Int32 /*[in]*/ Width, Int32 /*[in]*/ Height) throws ComException;

    void getWindowPosition(Int32 /*[out]*/ pLeft, Int32 /*[out]*/ pTop,
        Int32 /*[out]*/ pWidth, Int32 /*[out]*/ pHeight)
        throws ComException;

    void getMinIdealImageSize(Int32 /*[out]*/ pWidth, Int32 /*[out]*/ pHeight)
        throws ComException;

    void getMaxIdealImageSize(Int32 /*[out]*/ pWidth, Int32 /*[out]*/ pHeight)
        throws ComException;

    void getRestorePosition(Int32 /*[out]*/ pLeft, Int32 /*[out]*/ pTop,
        Int32 /*[out]*/ pWidth, Int32 /*[out]*/ pHeight)
        throws ComException;

    void hideCursor(Int32 /*[in]*/ HideCursor) throws ComException;

    Int32 isCursorHidden() throws ComException;
}
