/*
 * File:     IFilterInfoImpl.java
 * Project:  MPI Linguistic Application
 * Date:     03 April 2006
 *
 * Copyright (C) 2001-2006  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package mpi.eudico.client.annotator.nativemedia.quartztypelib.impl;

import com.jniwrapper.*;

import com.jniwrapper.win32.*;

import com.jniwrapper.win32.automation.*;

import com.jniwrapper.win32.automation.impl.*;

import com.jniwrapper.win32.automation.types.*;

import com.jniwrapper.win32.com.*;

import com.jniwrapper.win32.com.impl.*;

import com.jniwrapper.win32.com.types.*;

import mpi.eudico.client.annotator.nativemedia.quartztypelib.*;


/**
 * Represents COM interface IFilterInfo
 */
public class IFilterInfoImpl extends IDispatchImpl implements IFilterInfo {
    public static final String INTERFACE_IDENTIFIER = IFilterInfo.INTERFACE_IDENTIFIER;
    private static final IID _iid = IID.create(INTERFACE_IDENTIFIER);

    public IFilterInfoImpl() {
    }

    protected IFilterInfoImpl(IUnknownImpl that) throws ComException {
        super(that);
    }

    public IFilterInfoImpl(IUnknown that) throws ComException {
        super(that);
    }

    public IFilterInfoImpl(CLSID clsid, ClsCtx dwClsContext)
        throws ComException {
        super(clsid, dwClsContext);
    }

    public IFilterInfoImpl(CLSID clsid, IUnknownImpl pUnkOuter,
        ClsCtx dwClsContext) throws ComException {
        super(clsid, pUnkOuter, dwClsContext);
    }

    public IDispatch findPin(BStr /*[in]*/ strPinID) throws ComException {
        IDispatchImpl ppUnk = new IDispatchImpl();
        invokeStandardVirtualMethod(7, Function.STDCALL_CALLING_CONVENTION,
            new Parameter[] {
                (strPinID == null) ? (Parameter) PTR_NULL : new Const(strPinID),
                (ppUnk == null) ? (Parameter) PTR_NULL
                                : new Pointer.OutOnly((Parameter) ppUnk)
            });

        return ppUnk;
    }

    public BStr getName() throws ComException {
        BStr strName = new BStr();
        invokeStandardVirtualMethod(8, Function.STDCALL_CALLING_CONVENTION,
            new Parameter[] {
                (strName == null) ? (Parameter) PTR_NULL
                                  : new Pointer.OutOnly(strName)
            });

        return strName;
    }

    public BStr getVendorInfo() throws ComException {
        BStr strVendorInfo = new BStr();
        invokeStandardVirtualMethod(9, Function.STDCALL_CALLING_CONVENTION,
            new Parameter[] {
                (strVendorInfo == null) ? (Parameter) PTR_NULL
                                        : new Pointer.OutOnly(strVendorInfo)
            });

        return strVendorInfo;
    }

    public IUnknown getFilter() throws ComException {
        IUnknownImpl ppUnk = new IUnknownImpl();
        invokeStandardVirtualMethod(10, Function.STDCALL_CALLING_CONVENTION,
            new Parameter[] {
                (ppUnk == null) ? (Parameter) PTR_NULL
                                : new Pointer.OutOnly((Parameter) ppUnk)
            });

        return ppUnk;
    }

    public IDispatch getPins() throws ComException {
        IDispatchImpl ppUnk = new IDispatchImpl();
        invokeStandardVirtualMethod(11, Function.STDCALL_CALLING_CONVENTION,
            new Parameter[] {
                (ppUnk == null) ? (Parameter) PTR_NULL
                                : new Pointer.OutOnly((Parameter) ppUnk)
            });

        return ppUnk;
    }

    public Int32 getIsFileSource() throws ComException {
        Int32 pbIsSource = new Int32();
        invokeStandardVirtualMethod(12, Function.STDCALL_CALLING_CONVENTION,
            new Parameter[] {
                (pbIsSource == null) ? (Parameter) PTR_NULL
                                     : new Pointer.OutOnly(pbIsSource)
            });

        return pbIsSource;
    }

    public BStr getFilename() throws ComException {
        BStr pstrFilename = new BStr();
        invokeStandardVirtualMethod(13, Function.STDCALL_CALLING_CONVENTION,
            new Parameter[] {
                (pstrFilename == null) ? (Parameter) PTR_NULL
                                       : new Pointer.OutOnly(pstrFilename)
            });

        return pstrFilename;
    }

    public void setFilename(BStr /*[in]*/ pstrFilename)
        throws ComException {
        invokeStandardVirtualMethod(14, Function.STDCALL_CALLING_CONVENTION,
            new Parameter[] {
                (pstrFilename == null) ? (Parameter) PTR_NULL
                                       : new Const(pstrFilename)
            });
    }

    public IID getIID() {
        return _iid;
    }

    public Object clone() {
        IFilterInfoImpl that = null;

        try {
            that = new IFilterInfoImpl(this);
        } catch (ComException e) {
        }

        return that;
    }
}
